/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.protocoladapter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.tooling.internal.consumer.protocoladapter.MethodInvocation;
import org.gradle.tooling.internal.consumer.protocoladapter.MethodInvoker;
import org.gradle.tooling.internal.consumer.protocoladapter.TargetTypeProvider;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolToModelAdapter {
    private static final MethodInvoker NO_OP_HANDLER = new MethodInvoker(){

        public void invoke(MethodInvocation invocation) throws Throwable {
        }
    };
    private static final Object[] EMPTY = new Object[0];
    private static final Pattern IS_SUPPORT_METHOD = Pattern.compile("is(\\w+)Supported");
    private static final Pattern GETTER_METHOD = Pattern.compile("get(\\w+)");
    private static final Pattern IS_METHOD = Pattern.compile("is(\\w+)");
    private final TargetTypeProvider targetTypeProvider = new TargetTypeProvider();

    public <T, S> T adapt(Class<T> targetType, S protocolObject) {
        return this.adapt(targetType, protocolObject, NO_OP_HANDLER);
    }

    public <T, S> T adapt(Class<T> targetType, S protocolObject, MethodInvoker overrideMethodInvoker) {
        Class<T> target = this.targetTypeProvider.getTargetType(targetType, protocolObject);
        if (target.isInstance(protocolObject)) {
            return target.cast(protocolObject);
        }
        Object proxy = Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, (InvocationHandler)new InvocationHandlerImpl(protocolObject, overrideMethodInvoker));
        return target.cast(proxy);
    }

    public <T, S> T adapt(Class<T> targetType, S protocolObject, Class<?> mixInClass) {
        MixInMethodInvoker mixInMethodInvoker = new MixInMethodInvoker(mixInClass, new ReflectionMethodInvoker(NO_OP_HANDLER));
        T proxy = this.adapt(targetType, protocolObject, mixInMethodInvoker);
        mixInMethodInvoker.setProxy(proxy);
        return proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MixInMethodInvoker
    implements MethodInvoker {
        private Object proxy;
        private Object instance;
        private final Class<?> mixInClass;
        private final MethodInvoker next;
        private final ThreadLocal<MethodInvocation> current = new ThreadLocal();

        public MixInMethodInvoker(Class<?> mixInClass, MethodInvoker next) {
            this.mixInClass = mixInClass;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            if (this.current.get() != null) {
                return;
            }
            if (this.instance == null) {
                this.instance = new DirectInstantiator().newInstance(this.mixInClass, this.proxy);
            }
            MethodInvocation beanInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), invocation.getParameterTypes(), this.instance, invocation.getParameters());
            this.current.set(beanInvocation);
            try {
                this.next.invoke(beanInvocation);
            }
            finally {
                this.current.set(null);
            }
            if (beanInvocation.found()) {
                invocation.setResult(beanInvocation.getResult());
            }
        }

        public void setProxy(Object proxy) {
            this.proxy = proxy;
        }

        public Object getProxy() {
            return this.proxy;
        }
    }

    private static class SupportedPropertyInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SupportedPropertyInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            Matcher matcher = IS_SUPPORT_METHOD.matcher(invocation.getName());
            if (!matcher.matches()) {
                this.next.invoke(invocation);
                return;
            }
            String getterName = String.format("get%s", matcher.group(1));
            MethodInvocation getterInvocation = new MethodInvocation(getterName, invocation.getReturnType(), invocation.getGenericReturnType(), new Class[0], invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            invocation.setResult(getterInvocation.found());
        }
    }

    private static class SafeMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SafeMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found()) {
                return;
            }
            boolean getter = GETTER_METHOD.matcher(invocation.getName()).matches();
            if (!getter || invocation.getParameterTypes().length != 1) {
                return;
            }
            MethodInvocation getterInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), new Class[0], invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            if (getterInvocation.found() && getterInvocation.getResult() != null) {
                invocation.setResult(getterInvocation.getResult());
            } else {
                invocation.setResult(invocation.getParameters()[0]);
            }
        }
    }

    private static class PropertyCachingMethodInvoker
    implements MethodInvoker {
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Set<String> unknown = new HashSet<String>();
        private final MethodInvoker next;

        private PropertyCachingMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation method) throws Throwable {
            if ((GETTER_METHOD.matcher(method.getName()).matches() || IS_METHOD.matcher(method.getName()).matches()) && method.getParameterTypes().length == 0) {
                if (this.properties.containsKey(method.getName())) {
                    method.setResult(this.properties.get(method.getName()));
                    return;
                }
                if (this.unknown.contains(method.getName())) {
                    return;
                }
                this.next.invoke(method);
                if (!method.found()) {
                    this.unknown.add(method.getName());
                    return;
                }
                Object value = method.getResult();
                this.properties.put(method.getName(), value);
                return;
            }
            this.next.invoke(method);
        }
    }

    private class ReflectionMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker override;

        private ReflectionMethodInvoker(MethodInvoker override) {
            this.override = override;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            Object returnValue;
            Method targetMethod = this.locateMethod(invocation);
            if (targetMethod == null) {
                return;
            }
            try {
                returnValue = targetMethod.invoke(invocation.getDelegate(), invocation.getParameters());
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (returnValue == null || invocation.getReturnType().isInstance(returnValue)) {
                invocation.setResult(returnValue);
                return;
            }
            invocation.setResult(this.convert(returnValue, invocation.getGenericReturnType()));
        }

        private Method locateMethod(MethodInvocation invocation) {
            Method match;
            Class<?> sourceClass = invocation.getDelegate().getClass();
            try {
                match = sourceClass.getMethod(invocation.getName(), invocation.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            LinkedList queue = new LinkedList();
            queue.add(sourceClass);
            while (!queue.isEmpty()) {
                Class c = (Class)queue.removeFirst();
                try {
                    match = c.getMethod(invocation.getName(), invocation.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                for (Class<?> interfaceType : c.getInterfaces()) {
                    queue.addFirst(interfaceType);
                }
                if (c.getSuperclass() == null) continue;
                queue.addFirst(c.getSuperclass());
            }
            match.setAccessible(true);
            return match;
        }

        private Object convert(Object value, Type targetType) {
            ParameterizedType parameterizedTargetType;
            if (targetType instanceof ParameterizedType && (parameterizedTargetType = (ParameterizedType)targetType).getRawType().equals(DomainObjectSet.class)) {
                Type targetElementType = this.getElementType(parameterizedTargetType);
                ArrayList<Object> convertedElements = new ArrayList<Object>();
                for (Object element : (Iterable)value) {
                    convertedElements.add(this.convert(element, targetElementType));
                }
                return new ImmutableDomainObjectSet(convertedElements);
            }
            if (targetType instanceof Class) {
                if (((Class)targetType).isPrimitive()) {
                    return value;
                }
                return ProtocolToModelAdapter.this.adapt((Class)targetType, value, this.override);
            }
            throw new UnsupportedOperationException(String.format("Cannot convert object of %s to %s.", value.getClass(), targetType));
        }

        private Type getElementType(ParameterizedType type) {
            Type elementType = type.getActualTypeArguments()[0];
            if (elementType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)elementType;
                return wildcardType.getUpperBounds()[0];
            }
            return elementType;
        }
    }

    private static class ChainedMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker[] invokers;

        private ChainedMethodInvoker(MethodInvoker ... invokers) {
            this.invokers = invokers;
        }

        public void invoke(MethodInvocation method) throws Throwable {
            for (int i = 0; !method.found() && i < this.invokers.length; ++i) {
                MethodInvoker invoker = this.invokers[i];
                invoker.invoke(method);
            }
        }
    }

    private class InvocationHandlerImpl
    implements InvocationHandler {
        private final Object delegate;
        private final Method equalsMethod;
        private final Method hashCodeMethod;
        private final MethodInvoker invoker;

        public InvocationHandlerImpl(Object delegate, MethodInvoker overrideMethodInvoker) {
            this.delegate = delegate;
            this.invoker = new SupportedPropertyInvoker(new SafeMethodInvoker(new PropertyCachingMethodInvoker(new ChainedMethodInvoker(new MethodInvoker[]{overrideMethodInvoker, new ReflectionMethodInvoker(overrideMethodInvoker)}))));
            try {
                this.equalsMethod = Object.class.getMethod("equals", Object.class);
                this.hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            InvocationHandlerImpl other = (InvocationHandlerImpl)o;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Object invoke(Object target, Method method, Object[] params) throws Throwable {
            if (method.equals(this.equalsMethod)) {
                Object param = params[0];
                if (param == null || !Proxy.isProxyClass(param.getClass())) {
                    return false;
                }
                InvocationHandler other = Proxy.getInvocationHandler(param);
                return this.equals(other);
            }
            if (method.equals(this.hashCodeMethod)) {
                return this.hashCode();
            }
            MethodInvocation invocation = new MethodInvocation(method.getName(), method.getReturnType(), method.getGenericReturnType(), method.getParameterTypes(), this.delegate, params);
            this.invoker.invoke(invocation);
            if (!invocation.found()) {
                String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()";
                throw Exceptions.unsupportedMethod(methodName);
            }
            return invocation.getResult();
        }
    }
}

