/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.ServiceLocator;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.AbstractConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.AdaptedConnection;
import org.gradle.tooling.internal.consumer.connection.BuildActionRunnerBackedConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.InternalConnectionBackedConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.parameters.ConsumerConnectionParameters;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalConnection;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.GradleVersion;
import org.gradle.util.MutableURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolingImplementationLoader
implements ToolingImplementationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultToolingImplementationLoader.class);
    private final ClassLoader classLoader;

    public DefaultToolingImplementationLoader() {
        this(DefaultToolingImplementationLoader.class.getClassLoader());
    }

    DefaultToolingImplementationLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, ConsumerConnectionParameters connectionParameters) {
        LOGGER.debug("Using tooling provider from {}", (Object)distribution.getDisplayName());
        ClassLoader classLoader = this.createImplementationClassLoader(distribution, progressLoggerFactory);
        ServiceLocator serviceLocator = new ServiceLocator(classLoader);
        try {
            ServiceLocator.ServiceFactory<ConnectionVersion4> factory = serviceLocator.findFactory(ConnectionVersion4.class);
            if (factory == null) {
                Matcher m = Pattern.compile("\\w+Version(\\d+)").matcher(ConnectionVersion4.class.getSimpleName());
                m.matches();
                String protocolVersion = m.group(1);
                throw new UnsupportedVersionException(String.format("The specified %s is not supported by this tooling API version (%s, protocol version %s)", distribution.getDisplayName(), GradleVersion.current().getVersion(), protocolVersion));
            }
            ConnectionVersion4 connection = (ConnectionVersion4)factory.create();
            AbstractConsumerConnection adaptedConnection = connection instanceof BuildActionRunner ? new BuildActionRunnerBackedConsumerConnection(connection) : (connection instanceof InternalConnection ? new InternalConnectionBackedConsumerConnection(connection) : new AdaptedConnection(connection));
            ((AbstractConsumerConnection)adaptedConnection).configure(connectionParameters);
            return adaptedConnection;
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new GradleConnectionException(String.format("Could not create an instance of Tooling API implementation using the specified %s.", distribution.getDisplayName()), t);
        }
    }

    private ClassLoader createImplementationClassLoader(Distribution distribution, ProgressLoggerFactory progressLoggerFactory) {
        ClassPath implementationClasspath = distribution.getToolingImplementationClasspath(progressLoggerFactory);
        LOGGER.debug("Using tooling provider classpath: {}", (Object)implementationClasspath);
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(this.classLoader);
        filteringClassLoader.allowPackage("org.gradle.tooling.internal.protocol");
        return new MutableURLClassLoader((ClassLoader)filteringClassLoader, implementationClasspath.getAsURLArray());
    }
}

