/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.listener.ListenerManager;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressLoggingConnection
implements ConsumerConnection {
    private final ConsumerConnection connection;
    private final LoggingProvider loggingProvider;

    public ProgressLoggingConnection(ConsumerConnection connection, LoggingProvider loggingProvider) {
        this.connection = connection;
        this.loggingProvider = loggingProvider;
    }

    @Override
    public void stop() {
        this.connection.stop();
    }

    @Override
    public String getDisplayName() {
        return this.connection.getDisplayName();
    }

    @Override
    public VersionDetails getVersionDetails() {
        return this.connection.getVersionDetails();
    }

    @Override
    public <T> T run(final Class<T> type, final ConsumerOperationParameters operationParameters) {
        return this.run("Build", operationParameters, new BuildAction<T>(){

            @Override
            public T run(ConsumerConnection connection) {
                return connection.run(type, operationParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T run(String description, BuildOperationParametersVersion1 parameters, BuildAction<T> action) {
        ProgressListenerAdapter listener = new ProgressListenerAdapter(parameters.getProgressListener());
        ListenerManager listenerManager = this.loggingProvider.getListenerManager();
        listenerManager.addListener(listener);
        try {
            T t;
            ProgressLogger progressLogger = this.loggingProvider.getProgressLoggerFactory().newOperation(ProgressLoggingConnection.class);
            progressLogger.setDescription(description);
            progressLogger.started();
            try {
                t = action.run(this.connection);
                progressLogger.completed();
            }
            catch (Throwable throwable) {
                progressLogger.completed();
                throw throwable;
            }
            return t;
        }
        finally {
            listenerManager.removeListener(listener);
        }
    }

    private static class ProgressListenerAdapter
    implements ProgressListener {
        private final ProgressListenerVersion1 progressListener;

        public ProgressListenerAdapter(ProgressListenerVersion1 progressListener) {
            this.progressListener = progressListener;
        }

        public void started(ProgressStartEvent event) {
            this.progressListener.onOperationStart(event.getDescription());
        }

        public void progress(ProgressEvent event) {
        }

        public void completed(ProgressCompleteEvent event) {
            this.progressListener.onOperationEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BuildAction<T> {
        public T run(ConsumerConnection var1);
    }
}

