/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockingResultHandler<T>
implements ResultHandler<T> {
    private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
    private final Class<T> resultType;
    private static final Object NULL = new Object();

    public BlockingResultHandler(Class<T> resultType) {
        this.resultType = resultType;
    }

    public T getResult() {
        Object result;
        try {
            result = this.queue.take();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        if (result instanceof Throwable) {
            throw UncheckedException.throwAsUncheckedException((Throwable)result);
        }
        if (result == NULL) {
            return null;
        }
        return this.resultType.cast(result);
    }

    @Override
    public void onComplete(T result) {
        this.queue.add(result == null ? NULL : result);
    }

    @Override
    public void onFailure(GradleConnectionException failure) {
        this.queue.add(failure);
    }
}

