/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.internal.service.AbstractServiceRegistry;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator
extends AbstractServiceRegistry {
    private final ClassLoader classLoader;
    private final Map<Class<?>, Object> implementations = new ConcurrentHashMap();

    public ServiceLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doGet(Class<T> serviceType) throws UnknownServiceException {
        Map<Class<?>, Object> map = this.implementations;
        synchronized (map) {
            T implementation = serviceType.cast(this.implementations.get(serviceType));
            if (implementation == null) {
                implementation = ((ServiceFactory)this.getFactory((Class)serviceType)).create();
                this.implementations.put(serviceType, implementation);
            }
            return implementation;
        }
    }

    public <T> ServiceFactory<T> getFactory(Class<T> serviceType) throws UnknownServiceException {
        ServiceFactory<T> factory = this.findFactory(serviceType);
        if (factory == null) {
            throw new UnknownServiceException(serviceType, String.format("Could not find meta-data resource 'META-INF/services/%s' for service '%s'.", serviceType.getName(), serviceType.getName()));
        }
        return factory;
    }

    public <T> ServiceFactory<T> findFactory(Class<T> serviceType) {
        Class<T> implementationClass = this.findServiceImplementationClass(serviceType);
        if (implementationClass == null) {
            return null;
        }
        return new ServiceFactory<T>(serviceType, implementationClass);
    }

    <T> Class<? extends T> findServiceImplementationClass(Class<T> serviceType) {
        String implementationClassName;
        try {
            implementationClassName = this.findServiceImplementationClassName(serviceType);
        }
        catch (Exception e) {
            throw new ServiceLookupException(String.format("Could not determine implementation class for service '%s'.", serviceType.getName()), e);
        }
        if (implementationClassName == null) {
            return null;
        }
        try {
            Class<?> implClass = this.classLoader.loadClass(implementationClassName);
            if (!serviceType.isAssignableFrom(implClass)) {
                throw new RuntimeException(String.format("Implementation class '%s' is not assignable to service class '%s'.", implementationClassName, serviceType.getName()));
            }
            return implClass.asSubclass(serviceType);
        }
        catch (Throwable t) {
            throw new ServiceLookupException(String.format("Could not load implementation class '%s' for service '%s'.", implementationClassName, serviceType.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findServiceImplementationClassName(Class<?> serviceType) throws IOException {
        String resourceName = "META-INF/services/" + serviceType.getName();
        URL resource = this.classLoader.getResource(resourceName);
        if (resource == null) {
            return null;
        }
        InputStream inputStream = resource.openStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                if ((line = line.replaceAll("#.*", "").trim()).length() <= 0) continue;
                String string = line;
                return string;
            }
        }
        finally {
            inputStream.close();
        }
        throw new RuntimeException(String.format("No implementation class for service '%s' specified in resource '%s'.", serviceType.getName(), resource));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceFactory<T>
    implements Factory<T> {
        private final Class<T> serviceType;
        private final Class<? extends T> implementationClass;

        public ServiceFactory(Class<T> serviceType, Class<? extends T> implementationClass) {
            this.serviceType = serviceType;
            this.implementationClass = implementationClass;
        }

        public Class<? extends T> getImplementationClass() {
            return this.implementationClass;
        }

        @Override
        public T create() {
            return this.newInstance(new Object[0]);
        }

        public T newInstance(Object ... params) {
            DirectInstantiator instantiator = new DirectInstantiator();
            try {
                return instantiator.newInstance(this.implementationClass, params);
            }
            catch (ObjectInstantiationException t) {
                throw new RuntimeException(String.format("Could not create an implementation of service '%s'.", this.serviceType.getName()), t);
            }
        }
    }
}

