/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.eclipse;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.internal.protocol.ExternalDependencyVersion1;
import org.gradle.tooling.internal.protocol.eclipse.EclipseLinkedResourceVersion1;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectDependencyVersion2;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectVersion3;
import org.gradle.tooling.internal.protocol.eclipse.EclipseSourceDirectoryVersion1;
import org.gradle.tooling.internal.protocol.eclipse.EclipseTaskVersion1;
import org.gradle.tooling.model.GradleProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEclipseProject
implements EclipseProjectVersion3,
Serializable {
    private final String name;
    private final String path;
    private EclipseProjectVersion3 parent;
    private List<ExternalDependencyVersion1> classpath;
    private final List<EclipseProjectVersion3> children;
    private List<EclipseSourceDirectoryVersion1> sourceDirectories;
    private List<EclipseProjectDependencyVersion2> projectDependencies;
    private final String description;
    private final File projectDirectory;
    private Iterable<? extends EclipseTaskVersion1> tasks;
    private Iterable<? extends EclipseLinkedResourceVersion1> linkedResources;
    private GradleProject gradleProject;

    public DefaultEclipseProject(String name, String path, String description, File projectDirectory, Iterable<? extends EclipseProjectVersion3> children) {
        this.name = name;
        this.path = path;
        this.description = description;
        this.projectDirectory = projectDirectory;
        this.tasks = Collections.emptyList();
        this.children = Lists.newArrayList(children);
        this.classpath = Collections.emptyList();
        this.sourceDirectories = Collections.emptyList();
        this.projectDependencies = Collections.emptyList();
    }

    public String toString() {
        return String.format("project '%s'", this.path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EclipseProjectVersion3 getParent() {
        return this.parent;
    }

    @Override
    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setParent(EclipseProjectVersion3 parent) {
        this.parent = parent;
    }

    public List<EclipseProjectVersion3> getChildren() {
        return this.children;
    }

    @Override
    public Iterable<? extends EclipseSourceDirectoryVersion1> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(List<EclipseSourceDirectoryVersion1> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    @Override
    public Iterable<? extends EclipseProjectDependencyVersion2> getProjectDependencies() {
        return this.projectDependencies;
    }

    public void setProjectDependencies(List<EclipseProjectDependencyVersion2> projectDependencies) {
        this.projectDependencies = projectDependencies;
    }

    public List<ExternalDependencyVersion1> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<ExternalDependencyVersion1> classpath) {
        this.classpath = classpath;
    }

    @Override
    public Iterable<? extends EclipseTaskVersion1> getTasks() {
        return this.tasks;
    }

    public void setTasks(Iterable<? extends EclipseTaskVersion1> tasks) {
        this.tasks = tasks;
    }

    public Iterable<? extends EclipseLinkedResourceVersion1> getLinkedResources() {
        return this.linkedResources;
    }

    public void setLinkedResources(Iterable<? extends EclipseLinkedResourceVersion1> linkedResources) {
        this.linkedResources = linkedResources;
    }

    public GradleProject getGradleProject() {
        return this.gradleProject;
    }

    public DefaultEclipseProject setGradleProject(GradleProject gradleProject) {
        this.gradleProject = gradleProject;
        return this;
    }
}

