/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionDetails {
    private final GradleVersion gradleVersion;
    private static final GradleVersion M5 = GradleVersion.version((String)"1.0-milestone-5");
    private static final GradleVersion M6 = GradleVersion.version((String)"1.0-milestone-6");
    private static final GradleVersion M7 = GradleVersion.version((String)"1.0-milestone-7");
    private static final GradleVersion V1_1 = GradleVersion.version((String)"1.1");

    public VersionDetails(String version) {
        this.gradleVersion = GradleVersion.version((String)version);
    }

    public String getVersion() {
        return this.gradleVersion.getVersion();
    }

    public boolean supportsCompleteBuildEnvironment() {
        return this.gradleVersion.compareTo(M7) > 0;
    }

    public boolean clientHangsOnEarlyDaemonFailure() {
        return this.gradleVersion.equals((Object)M5) || this.gradleVersion.equals((Object)M6);
    }

    public boolean isPostM6Model(Class<?> internalModelType) {
        return !ModelMapping.getModelsUpToM6().containsValue(internalModelType) && internalModelType != Void.class;
    }

    public boolean supportsConfiguringJavaHome() {
        return this.gradleVersion.compareTo(M7) > 0;
    }

    public boolean supportsConfiguringJvmArguments() {
        return this.gradleVersion.compareTo(M7) > 0;
    }

    public boolean supportsConfiguringStandardInput() {
        return this.gradleVersion.compareTo(M7) > 0;
    }

    public boolean supportsRunningTasksWhenBuildingModel() {
        return this.gradleVersion.compareTo(V1_1) > 0;
    }

    public boolean supportsGradleProjectModel() {
        return this.gradleVersion.compareTo(M5) >= 0;
    }
}

