/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.parameters.ConsumerConnectionParameters;

public class CachingToolingImplementationLoader
implements ToolingImplementationLoader {
    private final ToolingImplementationLoader loader;
    private final Map<ClassPath, ConsumerConnection> connections = new HashMap<ClassPath, ConsumerConnection>();

    public CachingToolingImplementationLoader(ToolingImplementationLoader loader) {
        this.loader = loader;
    }

    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, ConsumerConnectionParameters connectionParameters) {
        ClassPath classpath = distribution.getToolingImplementationClasspath(progressLoggerFactory);
        ConsumerConnection connection = this.connections.get(classpath);
        if (connection == null) {
            connection = this.loader.create(distribution, progressLoggerFactory, connectionParameters);
            this.connections.put(classpath, connection);
        }
        return connection;
    }
}

