/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.tooling.internal.build.VersionOnlyBuildEnvironment;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.converters.GradleProjectConverter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.gradle.DefaultGradleProject;
import org.gradle.tooling.internal.protocol.InternalBuildEnvironment;
import org.gradle.tooling.internal.protocol.InternalGradleProject;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectVersion3;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProvider {
    public <T> T provide(ConsumerConnection connection, Class<T> type, ConsumerOperationParameters operationParameters) {
        VersionDetails version = connection.getVersionDetails();
        if (operationParameters.getJavaHome() != null && !version.supportsConfiguringJavaHome()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJavaHome() and buildLauncher.setJavaHome()");
        }
        if (operationParameters.getJvmArguments() != null && !version.supportsConfiguringJvmArguments()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJvmArguments() and buildLauncher.setJvmArguments()");
        }
        if (operationParameters.getStandardInput() != null && !version.supportsConfiguringStandardInput()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setStandardInput() and buildLauncher.setStandardInput()");
        }
        if (type != Void.class && operationParameters.getTasks() != null && !version.supportsRunningTasksWhenBuildingModel()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.forTasks()");
        }
        if (type == InternalBuildEnvironment.class && !version.supportsCompleteBuildEnvironment()) {
            VersionOnlyBuildEnvironment out = new VersionOnlyBuildEnvironment(version.getVersion());
            return type.cast(out);
        }
        if (version.clientHangsOnEarlyDaemonFailure() && version.isPostM6Model(type)) {
            String message = String.format("I don't know how to build a model of type '%s'.", type.getSimpleName());
            throw new UnsupportedOperationException(message);
        }
        if (type == InternalGradleProject.class && !version.supportsGradleProjectModel()) {
            EclipseProjectVersion3 project = connection.run(EclipseProjectVersion3.class, operationParameters);
            DefaultGradleProject gradleProject = new GradleProjectConverter().convert(project);
            return (T)gradleProject;
        }
        return connection.run(type, operationParameters);
    }
}

