/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.parameters.ConsumerConnectionParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyConsumerActionExecutor
implements ConsumerActionExecutor {
    private final Distribution distribution;
    private final ToolingImplementationLoader implementationLoader;
    private final LoggingProvider loggingProvider;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Set<Thread> executing = new HashSet<Thread>();
    private boolean stopped;
    private ConsumerConnection connection;
    ConsumerConnectionParameters connectionParameters;

    public LazyConsumerActionExecutor(Distribution distribution, ToolingImplementationLoader implementationLoader, LoggingProvider loggingProvider, boolean verboseLogging) {
        this.distribution = distribution;
        this.implementationLoader = implementationLoader;
        this.loggingProvider = loggingProvider;
        this.connectionParameters = new ConsumerConnectionParameters(verboseLogging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ConsumerConnection connection = null;
        this.lock.lock();
        try {
            this.stopped = true;
            while (!this.executing.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            connection = this.connection;
            this.connection = null;
        }
        finally {
            this.lock.unlock();
        }
        if (connection != null) {
            connection.stop();
        }
    }

    @Override
    public String getDisplayName() {
        return this.distribution.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(ConsumerAction<T> action) throws UnsupportedOperationException, IllegalStateException {
        try {
            ConsumerConnection connection = this.onStartAction();
            T t = action.run(connection);
            return t;
        }
        finally {
            this.onEndAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerConnection onStartAction() {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException("This connection has been stopped.");
            }
            this.executing.add(Thread.currentThread());
            if (this.connection == null) {
                this.connection = this.implementationLoader.create(this.distribution, this.loggingProvider.getProgressLoggerFactory(), this.connectionParameters);
            }
            ConsumerConnection consumerConnection = this.connection;
            return consumerConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEndAction() {
        this.lock.lock();
        try {
            this.executing.remove(Thread.currentThread());
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

