/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractModelProducer;
import org.gradle.tooling.internal.consumer.connection.AbstractPre12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.GradleBuildAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalConnectionBackedConsumerConnection
extends AbstractPre12ConsumerConnection {
    private final ModelProducer modelProducer;

    public InternalConnectionBackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, new R10M8VersionDetails(delegate.getMetaData().getVersion()), adapter);
        InternalConnectionBackedModelProducer consumerConnectionBackedModelProducer = new InternalConnectionBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (InternalConnection)delegate);
        this.modelProducer = new GradleBuildAdapterProducer(adapter, this.getVersionDetails(), modelMapping, consumerConnectionBackedModelProducer);
    }

    @Override
    protected <T> T doGetModel(Class<T> modelType, ConsumerOperationParameters operationParameters) {
        return this.modelProducer.produceModel(modelType, operationParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalConnectionBackedModelProducer
    extends AbstractModelProducer {
        private final InternalConnection delegate;

        public InternalConnectionBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, InternalConnection delegate) {
            super(adapter, versionDetails, modelMapping);
            this.delegate = delegate;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (!this.versionDetails.isModelSupported(type)) {
                throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
            }
            Class<?> protocolType = this.modelMapping.getProtocolType(type);
            return this.adapter.adapt(type, this.delegate.getTheModel(protocolType, operationParameters));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R10M8VersionDetails
    extends VersionDetails {
        public R10M8VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsGradleProjectModel() {
            return true;
        }

        @Override
        public boolean isModelSupported(Class<?> modelType) {
            return modelType.equals(Void.class) || modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(GradleProject.class) || modelType.equals(BuildEnvironment.class);
        }
    }
}

