/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.build.VersionOnlyBuildEnvironment;
import org.gradle.tooling.internal.consumer.connection.AbstractModelProducer;
import org.gradle.tooling.internal.consumer.connection.AbstractPre12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.GradleBuildAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.converters.GradleProjectConverter;
import org.gradle.tooling.internal.consumer.converters.PropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.ProjectVersion3;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectVersion3;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionVersion4BackedConsumerConnection
extends AbstractPre12ConsumerConnection {
    private final ModelProducer modelProducer;

    public ConnectionVersion4BackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, ConnectionVersion4BackedConsumerConnection.getMetaData(delegate), adapter);
        ConnectionVersion4BackedModelProducer consumerConnectionBackedModelProducer = new ConnectionVersion4BackedModelProducer(adapter, this.getVersionDetails(), modelMapping, delegate);
        GradleProjectAdapterProducer gradleProjectAdapterProducer = new GradleProjectAdapterProducer(adapter, this.getVersionDetails(), modelMapping, consumerConnectionBackedModelProducer);
        this.modelProducer = new GradleBuildAdapterProducer(adapter, this.getVersionDetails(), modelMapping, gradleProjectAdapterProducer);
    }

    private static VersionDetails getMetaData(ConnectionVersion4 delegate) {
        GradleVersion version = GradleVersion.version(delegate.getMetaData().getVersion());
        if (version.compareTo(GradleVersion.version("1.0-milestone-5")) < 0) {
            return new R10M3VersionDetails(delegate);
        }
        return new R10M5VersionDetails(delegate);
    }

    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        VersionDetails versionDetails = this.getVersionDetails();
        if (operationParameters.getJavaHome() != null) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJavaHome() and buildLauncher.setJavaHome()", versionDetails.getVersion());
        }
        if (operationParameters.getJvmArguments() != null) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJvmArguments() and buildLauncher.setJvmArguments()", versionDetails.getVersion());
        }
        if (operationParameters.getStandardInput() != null) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setStandardInput() and buildLauncher.setStandardInput()", versionDetails.getVersion());
        }
        return super.run(type, operationParameters);
    }

    @Override
    protected <T> T doGetModel(Class<T> modelType, ConsumerOperationParameters operationParameters) {
        return this.modelProducer.produceModel(modelType, operationParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GradleProjectAdapterProducer
    extends AbstractModelProducer {
        private final ModelProducer delegate;

        public GradleProjectAdapterProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, ModelProducer delegate) {
            super(adapter, versionDetails, modelMapping);
            this.delegate = delegate;
        }

        @Override
        public <T> T produceModel(Class<T> modelType, ConsumerOperationParameters operationParameters) {
            Action<SourceObjectMapping> mapper = new PropertyHandlerFactory().forVersion(this.versionDetails);
            if (modelType == GradleProject.class && !this.versionDetails.isModelSupported(GradleProject.class)) {
                EclipseProjectVersion3 project = this.delegate.produceModel(EclipseProjectVersion3.class, operationParameters);
                return this.adapter.adapt(modelType, new GradleProjectConverter().convert(project), mapper);
            }
            return this.delegate.produceModel(modelType, operationParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionVersion4BackedModelProducer
    extends AbstractModelProducer {
        private final ConnectionVersion4 delegate;
        private final Action<SourceObjectMapping> mapper;

        public ConnectionVersion4BackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, ConnectionVersion4 delegate) {
            super(adapter, versionDetails, modelMapping);
            this.delegate = delegate;
            this.mapper = new PropertyHandlerFactory().forVersion(versionDetails);
        }

        @Override
        public <T> T produceModel(Class<T> modelType, ConsumerOperationParameters operationParameters) {
            if (modelType == BuildEnvironment.class && !this.versionDetails.isModelSupported(BuildEnvironment.class)) {
                return this.adapter.adapt(modelType, new VersionOnlyBuildEnvironment(this.versionDetails.getVersion()), this.mapper);
            }
            if (!this.versionDetails.isModelSupported(modelType)) {
                throw Exceptions.unsupportedModel(modelType, this.versionDetails.getVersion());
            }
            Class<ProjectVersion3> protocolType = this.modelMapping.getProtocolType(modelType).asSubclass(ProjectVersion3.class);
            ProjectVersion3 model = this.delegate.getModel(protocolType, operationParameters);
            return this.adapter.adapt(modelType, model, this.mapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R10M5VersionDetails
    extends VersionDetails {
        public R10M5VersionDetails(ConnectionVersion4 delegate) {
            super(delegate.getMetaData().getVersion());
        }

        @Override
        public boolean supportsGradleProjectModel() {
            return true;
        }

        @Override
        public boolean isModelSupported(Class<?> modelType) {
            return modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(GradleProject.class) || modelType.equals(Void.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R10M3VersionDetails
    extends VersionDetails {
        public R10M3VersionDetails(ConnectionVersion4 delegate) {
            super(delegate.getMetaData().getVersion());
        }

        @Override
        public boolean isModelSupported(Class<?> modelType) {
            return modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProjectVersion3.class) || modelType.equals(EclipseProject.class) || modelType.equals(Void.class);
        }
    }
}

