/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConsumerConnection
implements ConsumerConnection {
    private final ConnectionVersion4 delegate;
    private final VersionDetails providerMetaData;

    public AbstractConsumerConnection(ConnectionVersion4 delegate, VersionDetails providerMetaData) {
        this.delegate = delegate;
        this.providerMetaData = providerMetaData;
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getMetaData().getDisplayName();
    }

    public VersionDetails getVersionDetails() {
        return this.providerMetaData;
    }

    public ConnectionVersion4 getDelegate() {
        return this.delegate;
    }

    public abstract void configure(ConsumerConnectionParameters var1);

    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        throw Exceptions.unsupportedFeature("execution of build actions provided by the tooling API client", this.getVersionDetails().getVersion(), "1.8");
    }
}

