/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.ConnectionFactory;
import org.gradle.tooling.internal.consumer.DefaultConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGradleConnector
extends GradleConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleConnector.class);
    private final ConnectionFactory connectionFactory;
    private final DistributionFactory distributionFactory;
    private Distribution distribution;
    private final DefaultConnectionParameters connectionParameters = new DefaultConnectionParameters();

    public DefaultGradleConnector(ConnectionFactory connectionFactory, DistributionFactory distributionFactory) {
        this.connectionFactory = connectionFactory;
        this.distributionFactory = distributionFactory;
    }

    public GradleConnector useInstallation(File gradleHome) {
        this.distribution = this.distributionFactory.getDistribution(gradleHome);
        return this;
    }

    public GradleConnector useGradleVersion(String gradleVersion) {
        this.distribution = this.distributionFactory.getDistribution(gradleVersion);
        return this;
    }

    public GradleConnector useDistribution(URI gradleDistribution) {
        this.distribution = this.distributionFactory.getDistribution(gradleDistribution);
        return this;
    }

    public GradleConnector useClasspathDistribution() {
        this.distribution = this.distributionFactory.getClasspathDistribution();
        return this;
    }

    public GradleConnector useDefaultDistribution() {
        this.distribution = null;
        return this;
    }

    public GradleConnector forProjectDirectory(File projectDir) {
        this.connectionParameters.setProjectDir(projectDir);
        return this;
    }

    public GradleConnector useGradleUserHomeDir(File gradleUserHomeDir) {
        this.distribution = this.distributionFactory.getDistributionForGradleUserHomeDir(this.distribution, gradleUserHomeDir);
        this.connectionParameters.setGradleUserHomeDir(gradleUserHomeDir);
        return this;
    }

    public GradleConnector searchUpwards(boolean searchUpwards) {
        this.connectionParameters.setSearchUpwards(searchUpwards);
        return this;
    }

    public GradleConnector embedded(boolean embedded) {
        this.connectionParameters.setEmbedded(embedded);
        return this;
    }

    public GradleConnector daemonMaxIdleTime(int timeoutValue, TimeUnit timeoutUnits) {
        this.connectionParameters.setDaemonMaxIdleTimeValue(timeoutValue);
        this.connectionParameters.setDaemonMaxIdleTimeUnits(timeoutUnits);
        return this;
    }

    public DefaultGradleConnector setVerboseLogging(boolean verboseLogging) {
        this.connectionParameters.setVerboseLogging(verboseLogging);
        return this;
    }

    public ProjectConnection connect() throws GradleConnectionException {
        LOGGER.debug("Connecting from tooling API consumer version {}", (Object)GradleVersion.current().getVersion());
        if (this.connectionParameters.getProjectDir() == null) {
            throw new IllegalStateException("A project directory must be specified before creating a connection.");
        }
        if (this.distribution == null) {
            this.distribution = this.distributionFactory.getDefaultDistribution(this.connectionParameters.getProjectDir(), this.connectionParameters.isSearchUpwards() != null ? this.connectionParameters.isSearchUpwards() : true);
        }
        return this.connectionFactory.create(this.distribution, this.connectionParameters);
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

