/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBuildLauncher
extends AbstractLongRunningOperation<DefaultBuildLauncher>
implements BuildLauncher {
    private final AsyncConsumerActionExecutor connection;

    public DefaultBuildLauncher(AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(new ConsumerOperationParameters(parameters));
        this.operationParameters.setTasks(Collections.<String>emptyList());
        this.connection = connection;
    }

    @Override
    protected DefaultBuildLauncher getThis() {
        return this;
    }

    @Override
    public BuildLauncher forTasks(String ... tasks) {
        this.operationParameters.setTasks(Arrays.asList(tasks));
        return this;
    }

    @Override
    public BuildLauncher forTasks(Task ... tasks) {
        this.forTasks(Arrays.asList(tasks));
        return this;
    }

    @Override
    public BuildLauncher forTasks(Iterable<? extends Task> tasks) {
        ArrayList<String> taskPaths = new ArrayList<String>();
        for (Task task : tasks) {
            taskPaths.add(task.getPath());
        }
        this.operationParameters.setTasks(taskPaths);
        return this;
    }

    @Override
    public void run() {
        BlockingResultHandler<Void> handler = new BlockingResultHandler<Void>(Void.class);
        this.run(handler);
        handler.getResult();
    }

    @Override
    public void run(ResultHandler<? super Void> handler) {
        this.connection.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return DefaultBuildLauncher.this.operationParameters;
            }

            @Override
            public Void run(ConsumerConnection connection) {
                return connection.run(Void.class, DefaultBuildLauncher.this.operationParameters);
            }
        }, new ResultHandlerAdapter(handler));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHandlerAdapter
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<Void> {
        public ResultHandlerAdapter(ResultHandler<? super Void> handler) {
            super(handler);
        }

        @Override
        protected String connectionFailureMessage(Throwable failure) {
            return String.format("Could not execute build using %s.", DefaultBuildLauncher.this.connection.getDisplayName());
        }
    }
}

