/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.listener.ListenerNotificationException;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastDispatch<T>
implements Dispatch<MethodInvocation> {
    private final Class<T> type;
    private final Map<Object, Dispatch<MethodInvocation>> handlers = new LinkedHashMap<Object, Dispatch<MethodInvocation>>();

    public BroadcastDispatch(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void add(Dispatch<MethodInvocation> dispatch) {
        this.handlers.put(dispatch, dispatch);
    }

    public void add(T listener) {
        this.handlers.put(listener, new ReflectionDispatch(listener));
    }

    public void add(String methodName, Action<?> action) {
        this.assertIsMethod(methodName);
        this.handlers.put(action, new ActionInvocationHandler(methodName, action));
    }

    private void assertIsMethod(String methodName) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", methodName, this.type.getSimpleName()));
    }

    public void remove(Object listener) {
        this.handlers.remove(listener);
    }

    private String getErrorMessage() {
        String typeDescription = this.type.getSimpleName().replaceAll("(\\p{Upper})", " $1").trim().toLowerCase();
        return String.format("Failed to notify %s.", typeDescription);
    }

    @Override
    public void dispatch(MethodInvocation invocation) {
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (Dispatch<MethodInvocation> handler : new ArrayList<Dispatch<MethodInvocation>>(this.handlers.values())) {
            try {
                handler.dispatch(invocation);
            }
            catch (UncheckedException e) {
                failures.add(e.getCause());
            }
            catch (Throwable t) {
                failures.add(t);
            }
        }
        if (failures.size() == 1 && failures.get(0) instanceof RuntimeException) {
            throw (RuntimeException)failures.get(0);
        }
        if (!failures.isEmpty()) {
            throw new ListenerNotificationException(this.getErrorMessage(), failures);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action action;

        public ActionInvocationHandler(String methodName, Action action) {
            this.methodName = methodName;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (message.getMethod().getName().equals(this.methodName)) {
                this.action.execute(message.getArguments()[0]);
            }
        }
    }
}

