/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jarjar.com.google.common.collect;

import java.util.Comparator;
import java.util.SortedSet;
import org.gradle.jarjar.com.google.common.annotations.GwtCompatible;
import org.gradle.jarjar.com.google.common.base.Preconditions;
import org.gradle.jarjar.com.google.common.collect.Ordering;
import org.gradle.jarjar.com.google.common.collect.SortedIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements);
        } else if (elements instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements).comparator();
        } else {
            return false;
        }
        return ((Object)comparator).equals(comparator2);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<E> result = sortedSet.comparator();
        if (result == null) {
            result = Ordering.natural();
        }
        return result;
    }
}

