/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jarjar.com.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import org.gradle.jarjar.com.google.common.annotations.GwtCompatible;
import org.gradle.jarjar.com.google.common.annotations.GwtIncompatible;
import org.gradle.jarjar.com.google.common.collect.ImmutableAsList;
import org.gradle.jarjar.com.google.common.collect.ImmutableCollection;
import org.gradle.jarjar.com.google.common.collect.ImmutableList;
import org.gradle.jarjar.com.google.common.collect.ImmutableMap;
import org.gradle.jarjar.com.google.common.collect.ImmutableSet;
import org.gradle.jarjar.com.google.common.collect.Maps;
import org.gradle.jarjar.com.google.common.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return Maps.valueIterator(((ImmutableSet)this.map.entrySet()).iterator());
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<V> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new SerializedForm<V>(this.map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="serialization")
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

