/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlingNotationParser<N, T>
implements NotationParser<N, T> {
    private final String targetTypeDisplayName;
    private final String invalidNotationMessage;
    private final NotationParser<N, T> delegate;

    public ErrorHandlingNotationParser(String targetTypeDisplayName, String invalidNotationMessage, NotationParser<N, T> delegate) {
        this.targetTypeDisplayName = targetTypeDisplayName;
        this.invalidNotationMessage = invalidNotationMessage;
        this.delegate = delegate;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.delegate.describe(candidateFormats);
    }

    @Override
    public T parseNotation(N notation) {
        Formatter message = new Formatter();
        if (notation == null) {
            message.format("Cannot convert a null value to an object of type %s.%n", this.targetTypeDisplayName);
        } else {
            try {
                return this.delegate.parseNotation(notation);
            }
            catch (UnsupportedNotationException e) {
                message.format("Cannot convert the provided notation to an object of type %s: %s.%n", this.targetTypeDisplayName, e.getNotation());
            }
        }
        message.format("The following types/formats are supported:", new Object[0]);
        ArrayList<String> formats = new ArrayList<String>();
        this.describe(formats);
        for (String format : formats) {
            message.format("%n  - %s", format);
        }
        if (GUtil.isTrue(this.invalidNotationMessage)) {
            message.format("%n%s", this.invalidNotationMessage);
        }
        throw new InvalidUserDataException(message.toString());
    }
}

