/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Object lock = new Object();
    private final CompositeProvider allServices = new CompositeProvider();
    private final OwnServices ownServices;
    private final CompositeProvider parentServices;
    private final String displayName;
    private boolean closed;

    public DefaultServiceRegistry() {
        this(null, Collections.emptyList());
    }

    public DefaultServiceRegistry(String displayName) {
        this(displayName, Collections.emptyList());
    }

    public DefaultServiceRegistry(ServiceRegistry ... parents) {
        this((String)null, parents);
    }

    public DefaultServiceRegistry(String displayName, ServiceRegistry ... parents) {
        this(displayName, Arrays.asList(parents));
    }

    public DefaultServiceRegistry(String displayName, Collection<? extends ServiceRegistry> parents) {
        this.displayName = displayName != null ? displayName : this.getClass().getSimpleName();
        this.parentServices = parents.isEmpty() ? null : new CompositeProvider();
        this.ownServices = new OwnServices();
        this.allServices.providers.add(this.ownServices);
        if (this.parentServices != null) {
            this.allServices.providers.add(this.parentServices);
            for (ServiceRegistry serviceRegistry : parents) {
                this.parentServices.providers.add(new ParentServices(serviceRegistry));
            }
        }
        this.findProviderMethods(this);
    }

    public static ServiceRegistry create(Object ... providers) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        for (Object provider : providers) {
            registry.addProvider(provider);
        }
        return registry;
    }

    public String toString() {
        return this.displayName;
    }

    private void findProviderMethods(Object target) {
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> type = target.getClass(); type != Object.class; type = type.getSuperclass()) {
            this.findDecoratorMethods(target, type, methods, this.ownServices);
            this.findFactoryMethods(target, type, methods, this.ownServices);
        }
        this.findConfigureMethod(target);
    }

    private void findConfigureMethod(Object target) {
        for (Class<?> type = target.getClass(); type != Object.class; type = type.getSuperclass()) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.getName().equals("configure")) continue;
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new ServiceLookupException(String.format("Method %s.%s() must return void.", type.getSimpleName(), method.getName()));
                }
                Object[] params = new Object[method.getGenericParameterTypes().length];
                DefaultLookupContext context = new DefaultLookupContext();
                for (int i = 0; i < method.getGenericParameterTypes().length; ++i) {
                    Type paramType = method.getGenericParameterTypes()[i];
                    if (paramType.equals(ServiceRegistration.class)) {
                        params[i] = this.newRegistration();
                        continue;
                    }
                    ServiceProvider paramProvider = context.find(paramType, this.allServices);
                    if (paramProvider == null) {
                        throw new ServiceLookupException(String.format("Cannot configure services using %s.%s() as required service of type %s is not available.", method.getDeclaringClass().getSimpleName(), method.getName(), DefaultServiceRegistry.format(paramType)));
                    }
                    params[i] = paramProvider.get();
                }
                try {
                    DefaultServiceRegistry.invoke(method, target, params);
                }
                catch (Exception e) {
                    throw new ServiceLookupException(String.format("Could not configure services using %s.%s().", method.getDeclaringClass().getSimpleName(), method.getName()), e);
                }
                return;
            }
        }
    }

    private void findFactoryMethods(Object target, Class<?> type, Set<String> factoryMethods, OwnServices ownServices) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || Modifier.isStatic(method.getModifiers())) continue;
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must not return void.", type.getSimpleName(), method.getName()));
            }
            if (!factoryMethods.add(method.getName())) continue;
            ownServices.add(new FactoryMethodService(target, method));
        }
    }

    private void findDecoratorMethods(Object target, Class<?> type, Set<String> decoratorMethods, OwnServices ownServices) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(method.getReturnType())) continue;
            if (this.parentServices == null) {
                throw new ServiceLookupException(String.format("Cannot use decorator method %s.%s() when no parent registry is provided.", type.getSimpleName(), method.getName()));
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must not return void.", type.getSimpleName(), method.getName()));
            }
            if (!decoratorMethods.add(method.getName())) continue;
            ownServices.add(new DecoratorMethodService(target, method));
        }
    }

    public void register(Action<? super ServiceRegistration> action) {
        action.execute(this.newRegistration());
    }

    private ServiceRegistration newRegistration() {
        return new ServiceRegistration(){

            @Override
            public <T> void add(Class<T> serviceType, T serviceInstance) {
                DefaultServiceRegistry.this.add(serviceType, serviceInstance);
            }

            @Override
            public void add(Class<?> serviceType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(serviceType));
            }

            @Override
            public void addProvider(Object provider) {
                DefaultServiceRegistry.this.addProvider(provider);
            }
        };
    }

    public <T> DefaultServiceRegistry add(Class<T> serviceType, T serviceInstance) {
        this.ownServices.add(new FixedInstanceService<T>(serviceType, serviceInstance));
        return this;
    }

    public DefaultServiceRegistry addProvider(Object provider) {
        this.findProviderMethods(provider);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                CompositeStoppable.stoppable(this.allServices).stop();
            }
            finally {
                this.closed = true;
            }
        }
    }

    private static String format(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            return aClass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(DefaultServiceRegistry.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i];
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(DefaultServiceRegistry.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", DefaultServiceRegistry.format(serviceType), this.displayName));
            }
            ArrayList result = new ArrayList();
            DefaultLookupContext context = new DefaultLookupContext();
            this.allServices.getAll(context, serviceType, result);
            return result;
        }
    }

    @Override
    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        return serviceType.cast(this.doGet(serviceType));
    }

    @Override
    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        return this.doGet(serviceType);
    }

    private Object doGet(Type serviceType) throws IllegalArgumentException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", DefaultServiceRegistry.format(serviceType), this.displayName));
            }
            DefaultLookupContext context = new DefaultLookupContext();
            ServiceProvider provider = context.find(serviceType, this.allServices);
            if (provider != null) {
                return provider.get();
            }
            throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", DefaultServiceRegistry.format(serviceType), this.displayName));
        }
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate factory for objects of type %s, as %s has been closed.", DefaultServiceRegistry.format(type), this.displayName));
            }
            DefaultLookupContext context = new DefaultLookupContext();
            ServiceProvider factory = this.allServices.getFactory(context, type);
            if (factory != null) {
                return (Factory)factory.get();
            }
            throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", DefaultServiceRegistry.format(type), this.displayName));
        }
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }

    private static Object invoke(Method method, Object target, Object ... args) {
        return JavaReflectionUtil.method(target, Object.class, method).invoke(target, args);
    }

    private ServiceProvider getThisAsProvider() {
        return new ServiceProvider(){

            public String getDisplayName() {
                return String.format("ServiceRegistry %s", DefaultServiceRegistry.this.displayName);
            }

            public Object get() {
                return DefaultServiceRegistry.this;
            }

            public void requiredBy(Provider provider) {
            }
        };
    }

    private static class DefaultLookupContext
    implements LookupContext {
        private final Set<Type> visiting = new HashSet<Type>();

        private DefaultLookupContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceProvider find(Type serviceType, Provider provider) {
            if (!this.visiting.add(serviceType)) {
                throw new ServiceValidationException(String.format("Cycle in dependencies of service of type %s.", DefaultServiceRegistry.format(serviceType)));
            }
            try {
                ParameterizedType parameterizedType;
                if (serviceType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)serviceType).getRawType().equals(Factory.class)) {
                    Type typeArg = parameterizedType.getActualTypeArguments()[0];
                    if (typeArg instanceof Class) {
                        ServiceProvider serviceProvider = provider.getFactory(this, (Class)typeArg);
                        return serviceProvider;
                    }
                    if (typeArg instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)typeArg;
                        if (wildcardType.getLowerBounds().length == 1 && wildcardType.getUpperBounds().length == 1 && wildcardType.getLowerBounds()[0] instanceof Class && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                            ServiceProvider serviceProvider = provider.getFactory(this, (Class)wildcardType.getLowerBounds()[0]);
                            return serviceProvider;
                        }
                        if (wildcardType.getLowerBounds().length == 0 && wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class) {
                            ServiceProvider serviceProvider = provider.getFactory(this, (Class)wildcardType.getUpperBounds()[0]);
                            return serviceProvider;
                        }
                    }
                }
                ServiceProvider serviceProvider = provider.getService(this, this.toSpec(serviceType));
                return serviceProvider;
            }
            finally {
                this.visiting.remove(serviceType);
            }
        }

        TypeSpec toSpec(Type serviceType) {
            if (serviceType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)serviceType;
                ArrayList<TypeSpec> paramSpecs = new ArrayList<TypeSpec>();
                for (Type paramType : parameterizedType.getActualTypeArguments()) {
                    paramSpecs.add(this.toSpec(paramType));
                }
                return new ParameterizedTypeSpec(serviceType, this.toSpec(parameterizedType.getRawType()), paramSpecs);
            }
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)serviceType;
                if (serviceClass.isArray()) {
                    throw new ServiceValidationException("Locating services with array type is not supported.");
                }
                if (serviceClass.isAnnotation()) {
                    throw new ServiceValidationException("Locating services with annotation type is not supported.");
                }
                return new ClassSpec(serviceClass);
            }
            throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(serviceType)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterizedTypeSpec
    implements TypeSpec {
        private final Type type;
        private final TypeSpec rawType;
        private final List<TypeSpec> paramSpecs;

        private ParameterizedTypeSpec(Type type, TypeSpec rawType, List<TypeSpec> paramSpecs) {
            this.type = type;
            this.rawType = rawType;
            this.paramSpecs = paramSpecs;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isSatisfiedBy(Type element) {
            if (element instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)element;
                if (!this.rawType.isSatisfiedBy(parameterizedType.getRawType())) {
                    return false;
                }
                for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                    Type type = parameterizedType.getActualTypeArguments()[i];
                    if (this.paramSpecs.get(i).isSatisfiedBy(type)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassSpec
    implements TypeSpec {
        private final Class<?> type;

        private ClassSpec(Class<?> type) {
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isSatisfiedBy(Type element) {
            if (element instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)element;
                if (parameterizedType.getRawType() instanceof Class) {
                    return this.type.isAssignableFrom((Class)parameterizedType.getRawType());
                }
            } else if (element instanceof Class) {
                Class other = (Class)element;
                return this.type.isAssignableFrom(other);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface TypeSpec
    extends Spec<Type> {
        public Type getType();
    }

    static interface LookupContext {
        @Nullable
        public ServiceProvider find(Type var1, Provider var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentServices
    implements Provider {
        private final ServiceRegistry parent;

        private ParentServices(ServiceRegistry parent) {
            this.parent = parent;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            try {
                Factory<?> factory = this.parent.getFactory(type);
                assert (factory != null) : String.format("parent returned null for factory type '%s'", type.getName());
                return this.wrap(factory);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(type)) {
                    throw e;
                }
                return null;
            }
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            try {
                Object service = this.parent.get(serviceType.getType());
                assert (service != null) : String.format("parent returned null for service type %s", DefaultServiceRegistry.access$700(serviceType.getType()));
                return this.wrap(service);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(serviceType.getType())) {
                    throw e;
                }
                return null;
            }
        }

        private ServiceProvider wrap(final Object instance) {
            return new ServiceProvider(){

                public String getDisplayName() {
                    return String.format("ServiceRegistry %s", ParentServices.this.parent);
                }

                public Object get() {
                    return instance;
                }

                public void requiredBy(Provider provider) {
                }
            };
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            List<T> services = this.parent.getAll(serviceType);
            assert (services != null) : String.format("parent returned null for services of type %s", DefaultServiceRegistry.access$700(serviceType));
            result.addAll(services);
        }

        @Override
        public void stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeProvider
    implements Provider {
        private final List<Provider> providers = new LinkedList<Provider>();

        private CompositeProvider() {
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            for (Provider provider : this.providers) {
                ServiceProvider service = provider.getService(context, serviceType);
                if (service == null) continue;
                return service;
            }
            return null;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            for (Provider provider : this.providers) {
                ServiceProvider factory = provider.getFactory(context, type);
                if (factory == null) continue;
                return factory;
            }
            return null;
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            for (Provider provider : this.providers) {
                provider.getAll(context, serviceType, result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable(this.providers).stop();
            }
            finally {
                this.providers.clear();
            }
        }
    }

    private class DecoratorMethodService
    extends SingletonService {
        private final Method method;
        private Object target;
        private ServiceProvider paramProvider;

        public DecoratorMethodService(Object target, Method method) {
            super(method.getGenericReturnType());
            this.target = target;
            this.method = method;
        }

        public String getDisplayName() {
            return String.format("Service %s at %s.%s()", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName());
        }

        protected void bind(LookupContext context) {
            Type paramType = this.method.getGenericParameterTypes()[0];
            DefaultLookupContext parentLookupContext = new DefaultLookupContext();
            this.paramProvider = parentLookupContext.find(paramType, DefaultServiceRegistry.this.parentServices);
            if (this.paramProvider == null) {
                throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available in parent registries.", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName(), DefaultServiceRegistry.format(paramType)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object create() {
            Object result;
            Object param = this.paramProvider.get();
            try {
                result = DefaultServiceRegistry.invoke(this.method, this.target, new Object[]{param});
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                this.paramProvider = null;
                this.target = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorService
    extends FactoryService {
        private final Constructor<?> constructor;

        private ConstructorService(Class<?> serviceType) {
            super(serviceType);
            Constructor<?>[] constructors = serviceType.getDeclaredConstructors();
            if (constructors.length != 1) {
                throw new ServiceValidationException(String.format("Expected a single constructor for %s.", DefaultServiceRegistry.format(serviceType)));
            }
            this.constructor = constructors[0];
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.constructor;
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (InvocationTargetException e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e.getCause());
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e);
            }
        }

        @Override
        public String getDisplayName() {
            return String.format("Service %s", DefaultServiceRegistry.format(this.serviceType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedInstanceService<T>
    extends SingletonService {
        public FixedInstanceService(Class<T> serviceType, T serviceInstance) {
            super(serviceType);
            this.setInstance(serviceInstance);
        }

        @Override
        public String getDisplayName() {
            return String.format("Service %s with implementation %s", DefaultServiceRegistry.format(this.serviceType), this.getInstance());
        }

        @Override
        protected Object create() {
            throw new UnsupportedOperationException();
        }
    }

    private class FactoryMethodService
    extends FactoryService {
        private final Method method;
        private Object target;

        public FactoryMethodService(Object target, Method method) {
            super(method.getGenericReturnType());
            this.target = target;
            this.method = method;
        }

        public String getDisplayName() {
            return String.format("Service %s at %s.%s()", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName());
        }

        protected Type[] getParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        protected Member getFactory() {
            return this.method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object invokeMethod(Object[] params) {
            Object result;
            try {
                result = DefaultServiceRegistry.invoke(this.method, this.target, params);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.serviceType), this.method.getDeclaringClass().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.serviceType), this.method.getDeclaringClass().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                this.target = null;
            }
        }
    }

    private abstract class FactoryService
    extends SingletonService {
        private ServiceProvider[] paramProviders;

        protected FactoryService(Type serviceType) {
            super(serviceType);
        }

        protected abstract Type[] getParameterTypes();

        protected abstract Member getFactory();

        protected void bind(LookupContext context) {
            Type[] parameterTypes = this.getParameterTypes();
            this.paramProviders = new ServiceProvider[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type paramType = parameterTypes[i];
                try {
                    if (paramType.equals(ServiceRegistry.class)) {
                        this.paramProviders[i] = DefaultServiceRegistry.this.getThisAsProvider();
                        continue;
                    }
                    ServiceProvider paramProvider = context.find(paramType, DefaultServiceRegistry.this.allServices);
                    if (paramProvider == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                    }
                    this.paramProviders[i] = paramProvider;
                    paramProvider.requiredBy(this);
                    continue;
                }
                catch (ServiceValidationException e) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as there is a problem with parameter #%s of type %s.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), i + 1, DefaultServiceRegistry.format(paramType)), e);
                }
            }
        }

        protected Object create() {
            Object[] params = this.assembleParameters();
            Object result = this.invokeMethod(params);
            this.paramProviders = null;
            return result;
        }

        private Object[] assembleParameters() {
            Object[] params = new Object[this.paramProviders.length];
            for (int i = 0; i < this.paramProviders.length; ++i) {
                ServiceProvider paramProvider = this.paramProviders[i];
                params[i] = paramProvider.get();
            }
            return params;
        }

        protected abstract Object invokeMethod(Object[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SingletonService
    extends ManagedObjectProvider<Object>
    implements ServiceProvider {
        final Type serviceType;
        final Class serviceClass;
        boolean bound;

        SingletonService(Type serviceType) {
            this.serviceType = serviceType;
            this.serviceClass = this.toClass(serviceType);
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public Object get() {
            return this.getInstance();
        }

        private ServiceProvider prepare(LookupContext context) {
            if (!this.bound) {
                this.bind(context);
                this.bound = true;
            }
            return this;
        }

        protected void bind(LookupContext context) {
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            if (!serviceType.isSatisfiedBy(this.serviceType)) {
                return null;
            }
            return this.prepare(context);
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            if (serviceType.isAssignableFrom(this.serviceClass)) {
                result.add(serviceType.cast(this.prepare(context).get()));
            }
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> elementType) {
            if (!this.isFactory(this.serviceType, elementType)) {
                return null;
            }
            return this.prepare(context);
        }

        private boolean isFactory(Type type, Class<?> elementType) {
            Type actualType;
            ParameterizedType parameterizedType;
            Class c = this.toClass(type);
            if (!Factory.class.isAssignableFrom(c)) {
                return false;
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class && elementType.isAssignableFrom((Class)actualType)) {
                return true;
            }
            for (Type interfaceType : c.getGenericInterfaces()) {
                if (!this.isFactory(interfaceType, elementType)) continue;
                return true;
            }
            return false;
        }

        private Class toClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ManagedObjectProvider<T>
    implements Provider {
        private T instance;
        private final Set<Provider> dependents = new HashSet<Provider>();

        private ManagedObjectProvider() {
        }

        protected void setInstance(T instance) {
            this.instance = instance;
        }

        public T getInstance() {
            if (this.instance == null) {
                this.instance = this.create();
                assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
            }
            return this.instance;
        }

        protected abstract T create();

        public void requiredBy(Provider provider) {
            this.dependents.add(provider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                if (this.instance != null) {
                    CompositeStoppable.stoppable(this.dependents).add(this.instance).stop();
                }
            }
            finally {
                this.dependents.clear();
                this.instance = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnServices
    implements Provider {
        private final List<Provider> providers = new ArrayList<Provider>();

        private OwnServices() {
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            ArrayList<ServiceProvider> candidates = new ArrayList<ServiceProvider>();
            for (Provider provider : this.providers) {
                ServiceProvider factory = provider.getFactory(context, type);
                if (factory == null) continue;
                candidates.add(factory);
            }
            if (candidates.size() == 0) {
                return null;
            }
            if (candidates.size() == 1) {
                return (ServiceProvider)candidates.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (ServiceProvider candidate : candidates) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple factories for objects of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.displayName);
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            ArrayList<ServiceProvider> candidates = new ArrayList<ServiceProvider>();
            for (Provider provider : this.providers) {
                ServiceProvider service = provider.getService(context, serviceType);
                if (service == null) continue;
                candidates.add(service);
            }
            if (candidates.size() == 0) {
                return null;
            }
            if (candidates.size() == 1) {
                return (ServiceProvider)candidates.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (ServiceProvider candidate : candidates) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple services of type %s available in %s:", DefaultServiceRegistry.format(serviceType.getType()), DefaultServiceRegistry.this.displayName);
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            for (Provider provider : this.providers) {
                provider.getAll(context, serviceType, result);
            }
        }

        @Override
        public void stop() {
            CompositeStoppable.stoppable(this.providers).stop();
        }

        public void add(Provider provider) {
            this.providers.add(provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Provider
    extends Stoppable {
        public ServiceProvider getService(LookupContext var1, TypeSpec var2);

        public ServiceProvider getFactory(LookupContext var1, Class<?> var2);

        public <T> void getAll(LookupContext var1, Class<T> var2, List<T> var3);
    }

    static interface ServiceProvider {
        public String getDisplayName();

        public Object get();

        public void requiredBy(Provider var1);
    }
}

