/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.file.pattern.PatternStep;

public class RegExpPatternStep
implements PatternStep {
    private static final String ESCAPE_CHARS = "\\[]^-&.{}()$+|<=!";
    private final Pattern pattern;

    public RegExpPatternStep(String pattern, boolean caseSensitive) {
        this.pattern = Pattern.compile(RegExpPatternStep.getRegExPattern(pattern), caseSensitive ? 0 : 2);
    }

    protected static String getRegExPattern(String pattern) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char next = pattern.charAt(i);
            if (next == '*') {
                result.append(".*");
                continue;
            }
            if (next == '?') {
                result.append(".");
                continue;
            }
            if (ESCAPE_CHARS.indexOf(next) >= 0) {
                result.append('\\');
                result.append(next);
                continue;
            }
            result.append(next);
        }
        return result.toString();
    }

    public boolean matches(String testString) {
        Matcher matcher = this.pattern.matcher(testString);
        return matcher.matches();
    }

    public boolean isGreedy() {
        return false;
    }
}

