/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPatternMatcher
implements Spec<RelativePath> {
    private List<PatternStep> steps;
    private boolean partialMatchDirs;

    public DefaultPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String ... patternParts) {
        this.partialMatchDirs = partialMatchDirs;
        this.steps = new ArrayList<PatternStep>();
        this.compile(caseSensitive, patternParts);
    }

    private void compile(boolean caseSensitive, String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            this.steps.add(PatternStepFactory.getStep(parts[i], caseSensitive));
        }
    }

    @Override
    public boolean isSatisfiedBy(RelativePath pathToTest) {
        String[] segments = pathToTest.getSegments();
        int nextSegment = 0;
        int nextPattern = 0;
        boolean seenGreedy = false;
        while (nextSegment < segments.length && nextPattern < this.steps.size()) {
            String currentSegment = segments[nextSegment];
            ++nextSegment;
            PatternStep currentPattern = this.steps.get(nextPattern);
            ++nextPattern;
            if (currentPattern.isGreedy()) {
                seenGreedy = true;
                while (nextPattern < this.steps.size() && this.steps.get(nextPattern).isGreedy()) {
                    ++nextPattern;
                }
                if (nextPattern == this.steps.size()) {
                    return true;
                }
                currentPattern = this.steps.get(nextPattern);
                ++nextPattern;
                while (!currentPattern.matches(currentSegment)) {
                    if (nextSegment == segments.length) {
                        return this.partialMatchDirs && !pathToTest.isFile();
                    }
                    currentSegment = segments[nextSegment];
                    ++nextSegment;
                }
                continue;
            }
            if (currentPattern.matches(currentSegment)) continue;
            if (seenGreedy) {
                --nextPattern;
                while (!this.steps.get(nextPattern).isGreedy()) {
                    --nextPattern;
                }
                --nextSegment;
                continue;
            }
            return false;
        }
        if (nextSegment == segments.length && nextPattern == this.steps.size()) {
            return true;
        }
        if (nextPattern == this.steps.size() - 1 && this.steps.get(nextPattern).isGreedy()) {
            return true;
        }
        return !pathToTest.isFile() && this.partialMatchDirs;
    }

    List<PatternStep> getStepsForTest() {
        return this.steps;
    }
}

