/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.model.internal;

import org.gradle.tooling.model.UnsupportedMethodException;

public class Exceptions {
    public static final String INCOMPATIBLE_VERSION_HINT = "Most likely the model of that type is not supported in the target Gradle version.\nTo resolve the problem you can change/upgrade the Gradle version the tooling api connects to.";

    public static UnsupportedMethodException unsupportedModelMethod(String method, Throwable cause) {
        return new UnsupportedMethodException(Exceptions.formatUnsupportedModelMethod(method), cause);
    }

    public static UnsupportedMethodException unsupportedModelMethod(String method) {
        return new UnsupportedMethodException(Exceptions.formatUnsupportedModelMethod(method));
    }

    private static String formatUnsupportedModelMethod(String method) {
        return String.format("Unsupported method: %s.\nThe version of Gradle you connect to does not support that method.\nTo resolve the problem you can change/upgrade the target version of Gradle you connect to.\nAlternatively, you can ignore this exception and read other information from the model.", method);
    }

    public static UnsupportedMethodException unsupportedOperationConfiguration(String operation) {
        return new UnsupportedMethodException(String.format("Unsupported configuration: %s.\nYou configured the LongRunningOperation (ModelBuilder or BuildLauncher) with an unsupported option.\nThe version of Gradle you connect to does not support this configuration option.\nTo resolve the problem you can change/upgrade the target version of Gradle you connect to.\nAlternatively, please stop using this configuration option.", operation));
    }
}

