/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.reflect;

import java.lang.reflect.Method;
import org.gradle.tooling.model.UnsupportedMethodException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleIntrospector {
    private final Object target;

    public CompatibleIntrospector(Object target) {
        this.target = target;
    }

    private Method getMethod(String methodName) {
        try {
            return this.target.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedMethodException("The method: " + methodName + " is not supported on instance: " + this.target + ".\n", e);
        }
    }

    public <T> T getSafely(T defaultValue, String methodName) {
        try {
            Method method = this.getMethod(methodName);
            method.setAccessible(true);
            return (T)method.invoke(this.target, new Object[0]);
        }
        catch (UnsupportedMethodException e) {
            return defaultValue;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value reflectively", e);
        }
    }

    public boolean isConfigured(String methodName) {
        return this.getSafely(null, methodName) != null;
    }
}

