/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.internal.Exceptions;

public class FeatureValidator {
    public void validate(ConsumerConnection connection, ConsumerOperationParameters operationParameters) {
        VersionDetails version = connection.getMetaData().getVersionDetails();
        if (operationParameters.getJavaHome() != null && !version.supportsConfiguringJavaHome()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJavaHome() and buildLauncher.setJavaHome()");
        }
        if (operationParameters.getJvmArguments() != null && !version.supportsConfiguringJvmArguments()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJvmArguments() and buildLauncher.setJvmArguments()");
        }
        if (operationParameters.getStandardInput() != null && !version.supportsConfiguringStandardInput()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setStandardInput() and buildLauncher.setStandardInput()");
        }
    }
}

