/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.ProgressListenerAdapter;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.util.JavaHomeException;
import org.gradle.util.Jvm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerOperationParameters
implements BuildOperationParametersVersion1 {
    private final ProgressListenerAdapter progressListener = new ProgressListenerAdapter();
    private final ConnectionParameters parameters;
    private final long startTime = System.currentTimeMillis();
    private OutputStream stdout;
    private OutputStream stderr;
    private InputStream stdin;
    private File javaHome;
    private List<String> jvmArguments;

    public ConsumerOperationParameters(ConnectionParameters parameters) {
        this.parameters = parameters;
    }

    public void setStandardOutput(OutputStream outputStream) {
        this.stdout = outputStream;
    }

    public void setStandardError(OutputStream outputStream) {
        this.stderr = outputStream;
    }

    public void setStandardInput(InputStream inputStream) {
        this.stdin = inputStream;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListener.add(listener);
    }

    public void setJavaHome(File javaHome) {
        this.validateJavaHome(javaHome);
        this.javaHome = javaHome;
    }

    private void validateJavaHome(File javaHome) {
        if (javaHome == null) {
            return;
        }
        if (!javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome is not a valid folder. You supplied: " + javaHome);
        }
        try {
            Jvm.forHome((File)javaHome);
        }
        catch (JavaHomeException e) {
            throw new IllegalArgumentException("Supplied javaHome does not seem to be a valid java location. You supplied: " + javaHome + "." + " I could not find the java executable in that location.", e);
        }
    }

    public void setJvmArguments(String ... jvmArguments) {
        this.jvmArguments = jvmArguments != null ? Arrays.asList(jvmArguments) : null;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean getVerboseLogging() {
        return this.parameters.getVerboseLogging();
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.parameters.getGradleUserHomeDir();
    }

    @Override
    public File getProjectDir() {
        return this.parameters.getProjectDir();
    }

    @Override
    public Boolean isSearchUpwards() {
        return this.parameters.isSearchUpwards();
    }

    @Override
    public Boolean isEmbedded() {
        return this.parameters.isEmbedded();
    }

    @Override
    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.parameters.getDaemonMaxIdleTimeUnits();
    }

    @Override
    public Integer getDaemonMaxIdleTimeValue() {
        return this.parameters.getDaemonMaxIdleTimeValue();
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.stdout;
    }

    @Override
    public OutputStream getStandardError() {
        return this.stderr;
    }

    @Override
    public ProgressListenerVersion1 getProgressListener() {
        return this.progressListener;
    }

    @Override
    public InputStream getStandardInput() {
        return this.stdin;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }
}

