/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.ModelProvider;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnectionMetadata;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.FeatureValidator;
import org.gradle.tooling.internal.protocol.BuildParametersVersion1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyConnection
implements ConsumerConnection {
    private final Distribution distribution;
    private final ToolingImplementationLoader implementationLoader;
    private final LoggingProvider loggingProvider;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Set<Thread> executing = new HashSet<Thread>();
    private boolean stopped;
    private ConsumerConnection connection;
    ModelProvider modelProvider = new ModelProvider();
    FeatureValidator featureValidator = new FeatureValidator();

    public LazyConnection(Distribution distribution, ToolingImplementationLoader implementationLoader, LoggingProvider loggingProvider) {
        this.distribution = distribution;
        this.implementationLoader = implementationLoader;
        this.loggingProvider = loggingProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ConsumerConnection connection = null;
        this.lock.lock();
        try {
            this.stopped = true;
            while (!this.executing.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.asUncheckedException((Throwable)e);
                }
            }
            connection = this.connection;
            this.connection = null;
        }
        finally {
            this.lock.unlock();
        }
        if (connection != null) {
            connection.stop();
        }
    }

    @Override
    public ConsumerConnectionMetadata getMetaData() {
        return new ConsumerConnectionMetadata(this.distribution.getDisplayName(), null);
    }

    @Override
    public void executeBuild(final BuildParametersVersion1 buildParameters, final ConsumerOperationParameters operationParameters) {
        this.withConnection(new ConnectionAction<Object>(){

            @Override
            public Object run(ConsumerConnection connection) {
                LazyConnection.this.featureValidator.validate(connection, operationParameters);
                connection.executeBuild(buildParameters, operationParameters);
                return null;
            }
        });
    }

    @Override
    public <T> T getModel(final Class<T> type, final ConsumerOperationParameters operationParameters) {
        return this.withConnection(new ConnectionAction<T>(){

            @Override
            public T run(ConsumerConnection connection) {
                LazyConnection.this.featureValidator.validate(connection, operationParameters);
                return LazyConnection.this.modelProvider.provide(connection, type, operationParameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withConnection(ConnectionAction<T> action) {
        try {
            ConsumerConnection connection = this.onStartAction();
            T t = action.run(connection);
            return t;
        }
        finally {
            this.onEndAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerConnection onStartAction() {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException("This connection has been stopped.");
            }
            this.executing.add(Thread.currentThread());
            if (this.connection == null) {
                this.connection = this.implementationLoader.create(this.distribution, this.loggingProvider.getProgressLoggerFactory());
            }
            ConsumerConnection consumerConnection = this.connection;
            return consumerConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEndAction() {
        this.lock.lock();
        try {
            this.executing.remove(Thread.currentThread());
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ConnectionAction<T> {
        public T run(ConsumerConnection var1);
    }
}

