/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.async;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.tooling.internal.consumer.async.AsyncConnection;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.BuildParametersVersion1;
import org.gradle.tooling.internal.protocol.ResultHandlerVersion1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAsyncConnection
implements AsyncConnection {
    private final ConsumerConnection connection;
    private final StoppableExecutor executor;
    private final AtomicBoolean closed = new AtomicBoolean();

    public DefaultAsyncConnection(ConsumerConnection connection, ExecutorFactory executorFactory) {
        this.connection = connection;
        this.executor = executorFactory.create("Connection worker");
    }

    @Override
    public String getDisplayName() {
        return this.connection.getMetaData().getDisplayName();
    }

    @Override
    public void executeBuild(final BuildParametersVersion1 buildParameters, final ConsumerOperationParameters operationParameters, ResultHandlerVersion1<? super Void> handler) throws IllegalStateException {
        this.runLater(handler, new ConnectionAction<Void>(){

            @Override
            public Void run() {
                DefaultAsyncConnection.this.connection.executeBuild(buildParameters, operationParameters);
                return null;
            }
        });
    }

    @Override
    public <T> void getModel(final Class<T> type, final ConsumerOperationParameters operationParameters, ResultHandlerVersion1<T> handler) throws UnsupportedOperationException, IllegalStateException {
        this.runLater(handler, new ConnectionAction<T>(){

            @Override
            public T run() {
                return DefaultAsyncConnection.this.connection.getModel(type, operationParameters);
            }
        });
    }

    @Override
    public void stop() {
        this.closed.set(true);
        this.executor.stop();
        this.connection.stop();
    }

    private <T> void runLater(final ResultHandlerVersion1<? super T> handler, final ConnectionAction<T> action) {
        this.onStartOperation();
        this.executor.execute(new Runnable(){

            public void run() {
                Object result;
                try {
                    result = action.run();
                }
                catch (Throwable t) {
                    handler.onFailure(t);
                    return;
                }
                handler.onComplete(result);
            }
        });
    }

    private void onStartOperation() {
        if (this.closed.get()) {
            throw new IllegalStateException("This connection has been closed.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ConnectionAction<T> {
        public T run();
    }
}

