/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.api.internal.Operation;
import org.gradle.api.internal.concurrent.Synchronizer;
import org.gradle.internal.Factory;
import org.gradle.listener.DefaultListenerManager;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.util.TimeProvider;
import org.gradle.util.TrueTimeProvider;

public class SynchronizedLogging
implements LoggingProvider {
    private final ThreadLocal<ListenerManager> listenerManager = new ThreadLocal();
    private final ThreadLocal<DefaultProgressLoggerFactory> progressLoggerFactory = new ThreadLocal();
    private final Synchronizer synchronizer = new Synchronizer();

    public ListenerManager getListenerManager() {
        return (ListenerManager)this.synchronizer.synchronize((Factory)new Factory<ListenerManager>(){

            public ListenerManager create() {
                SynchronizedLogging.this.assertInitialized();
                return (ListenerManager)SynchronizedLogging.this.listenerManager.get();
            }
        });
    }

    public DefaultProgressLoggerFactory getProgressLoggerFactory() {
        return (DefaultProgressLoggerFactory)this.synchronizer.synchronize((Factory)new Factory<DefaultProgressLoggerFactory>(){

            public DefaultProgressLoggerFactory create() {
                SynchronizedLogging.this.assertInitialized();
                return (DefaultProgressLoggerFactory)SynchronizedLogging.this.progressLoggerFactory.get();
            }
        });
    }

    public void init() {
        this.synchronizer.synchronize(new Operation(){

            public void execute() {
                DefaultListenerManager manager = new DefaultListenerManager();
                SynchronizedLogging.this.listenerManager.set(manager);
                SynchronizedLogging.this.progressLoggerFactory.set(new DefaultProgressLoggerFactory((ProgressListener)manager.getBroadcaster(ProgressListener.class), (TimeProvider)new TrueTimeProvider()));
            }
        });
    }

    private void assertInitialized() {
        if (this.listenerManager.get() == null) {
            throw new IllegalStateException("Internal problem. Logging has not yet been initialized for this thread.");
        }
    }
}

