/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.ResultHandlerVersion1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ResultHandlerAdapter<T>
implements ResultHandlerVersion1<T> {
    private final ResultHandler<? super T> handler;

    ResultHandlerAdapter(ResultHandler<? super T> handler) {
        this.handler = handler;
    }

    @Override
    public void onComplete(T result) {
        this.handler.onComplete(result);
    }

    @Override
    public void onFailure(Throwable failure) {
        if (failure instanceof GradleConnectionException) {
            this.handler.onFailure((GradleConnectionException)failure);
        } else if (failure instanceof BuildExceptionVersion1) {
            this.handler.onFailure(new BuildException(this.connectionFailureMessage(failure), failure.getCause()));
        } else {
            this.handler.onFailure(new GradleConnectionException(this.connectionFailureMessage(failure), failure));
        }
    }

    protected abstract String connectionFailureMessage(Throwable var1);
}

