/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolToModelAdapter {
    Map<String, Class<?>> configuredTargetTypes = new HashMap();

    public ProtocolToModelAdapter() {
        this.configuredTargetTypes.put(IdeaSingleEntryLibraryDependency.class.getCanonicalName(), IdeaSingleEntryLibraryDependency.class);
        this.configuredTargetTypes.put(IdeaModuleDependency.class.getCanonicalName(), IdeaModuleDependency.class);
    }

    public <T, S> T adapt(Class<T> targetType, S protocolObject) {
        Class<T> target = this.guessTarget(targetType, protocolObject);
        Object proxy = Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, (InvocationHandler)new InvocationHandlerImpl(protocolObject));
        return target.cast(proxy);
    }

    private <T, S> Class<T> guessTarget(Class<T> targetType, S protocolObject) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = protocolObject.getClass().getInterfaces()) {
            if (!this.configuredTargetTypes.containsKey(i.getName())) continue;
            return this.configuredTargetTypes.get(i.getName());
        }
        return targetType;
    }

    private class InvocationHandlerImpl
    implements InvocationHandler {
        private final Object delegate;
        private final Map<Method, Method> methods = new HashMap<Method, Method>();
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Method equalsMethod;
        private final Method hashCodeMethod;

        public InvocationHandlerImpl(Object delegate) {
            this.delegate = delegate;
            try {
                this.equalsMethod = Object.class.getMethod("equals", Object.class);
                this.hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw UncheckedException.asUncheckedException((Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            InvocationHandlerImpl other = (InvocationHandlerImpl)o;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Object invoke(Object target, Method method, Object[] params) throws Throwable {
            if (method.equals(this.equalsMethod)) {
                Object param = params[0];
                if (param == null || !Proxy.isProxyClass(param.getClass())) {
                    return false;
                }
                InvocationHandler other = Proxy.getInvocationHandler(param);
                return this.equals(other);
            }
            if (method.equals(this.hashCodeMethod)) {
                return this.hashCode();
            }
            if (method.getName().matches("get\\w+")) {
                if (this.properties.containsKey(method.getName())) {
                    return this.properties.get(method.getName());
                }
                Object value = this.doInvokeMethod(method, params);
                this.properties.put(method.getName(), value);
                return value;
            }
            return this.doInvokeMethod(method, params);
        }

        private Object doInvokeMethod(Method method, Object[] params) throws Throwable {
            Object returnValue;
            Method targetMethod = this.methods.get(method);
            if (targetMethod == null) {
                targetMethod = this.findMethod(method);
                this.methods.put(method, targetMethod);
            }
            try {
                returnValue = targetMethod.invoke(this.delegate, params);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (returnValue == null || method.getReturnType().isInstance(returnValue)) {
                return returnValue;
            }
            return this.convert(returnValue, method.getGenericReturnType());
        }

        private Method findMethod(Method method) {
            Method match;
            try {
                match = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()";
                throw Exceptions.unsupportedModelMethod(methodName, e);
            }
            LinkedList queue = new LinkedList();
            queue.add(this.delegate.getClass());
            while (!queue.isEmpty()) {
                Class c = (Class)queue.removeFirst();
                try {
                    match = c.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                for (Class<?> interfaceType : c.getInterfaces()) {
                    queue.addFirst(interfaceType);
                }
                if (c.getSuperclass() == null) continue;
                queue.addFirst(c.getSuperclass());
            }
            match.setAccessible(true);
            return match;
        }

        private Object convert(Object value, Type targetType) {
            ParameterizedType parameterizedTargetType;
            if (targetType instanceof ParameterizedType && (parameterizedTargetType = (ParameterizedType)targetType).getRawType().equals(DomainObjectSet.class)) {
                Type targetElementType = this.getElementType(parameterizedTargetType);
                ArrayList<Object> convertedElements = new ArrayList<Object>();
                for (Object element : (Iterable)value) {
                    convertedElements.add(this.convert(element, targetElementType));
                }
                return new ImmutableDomainObjectSet(convertedElements);
            }
            if (targetType instanceof Class) {
                if (((Class)targetType).isPrimitive()) {
                    return value;
                }
                return ProtocolToModelAdapter.this.adapt((Class)targetType, value);
            }
            throw new UnsupportedOperationException(String.format("Cannot convert object of %s to %s.", value.getClass(), targetType));
        }

        private Type getElementType(ParameterizedType type) {
            Type elementType = type.getActualTypeArguments()[0];
            if (elementType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)elementType;
                return wildcardType.getUpperBounds()[0];
            }
            return elementType;
        }
    }
}

