/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.tooling.internal.build.VersionOnlyBuildEnvironment;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.InternalBuildEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProvider {
    public <T> T provide(ConsumerConnection connection, Class<T> type, ConsumerOperationParameters operationParameters) {
        VersionDetails version = connection.getMetaData().getVersionDetails();
        if (type == InternalBuildEnvironment.class && !version.supportsCompleteBuildEnvironment()) {
            VersionOnlyBuildEnvironment out = new VersionOnlyBuildEnvironment(version.getVersion());
            return type.cast(out);
        }
        if (version.clientHangsOnEarlyDaemonFailure() && version.isPostM6Model(type)) {
            String message = String.format("I don't know how to build a model of type '%s'.", type.getSimpleName());
            throw new UnsupportedOperationException(message);
        }
        return connection.getModel(type, operationParameters);
    }
}

