/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultBuildLauncher;
import org.gradle.tooling.internal.consumer.DefaultModelBuilder;
import org.gradle.tooling.internal.consumer.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.async.AsyncConnection;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultProjectConnection
implements ProjectConnection {
    private final AsyncConnection connection;
    private final ModelMapping modelMapping = new ModelMapping();
    private ProtocolToModelAdapter adapter;
    private final ConnectionParameters parameters;

    public DefaultProjectConnection(AsyncConnection connection, ProtocolToModelAdapter adapter, ConnectionParameters parameters) {
        this.connection = connection;
        this.parameters = parameters;
        this.adapter = adapter;
    }

    @Override
    public void close() {
        this.connection.stop();
    }

    @Override
    public <T extends Model> T getModel(Class<T> viewType) {
        return this.model(viewType).get();
    }

    @Override
    public <T extends Model> void getModel(Class<T> viewType, ResultHandler<? super T> handler) {
        this.model(viewType).get(handler);
    }

    @Override
    public BuildLauncher newBuild() {
        return new DefaultBuildLauncher(this.connection, this.parameters);
    }

    @Override
    public <T extends Model> ModelBuilder<T> model(Class<T> modelType) {
        return new DefaultModelBuilder(modelType, this.mapToProtocol(modelType), this.connection, this.adapter, this.parameters);
    }

    private Class mapToProtocol(Class<? extends Model> viewType) {
        Class protocolViewType = this.modelMapping.getInternalType(viewType);
        if (protocolViewType == null) {
            throw new UnknownModelException("Unknown model: '" + viewType.getSimpleName() + "'.\n" + "Most likely you are trying to acquire a model for a class that is not a valid Tooling API model class.\n" + "Review the documentation on the version of Tooling API you use to find out what models can be build.");
        }
        return protocolViewType;
    }
}

