/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultProjectConnection;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.SynchronizedLogging;
import org.gradle.tooling.internal.consumer.async.DefaultAsyncConnection;
import org.gradle.tooling.internal.consumer.connection.LazyConnection;
import org.gradle.tooling.internal.consumer.connection.LoggingInitializerConnection;
import org.gradle.tooling.internal.consumer.connection.ProgressLoggingConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class ConnectionFactory {
    private final ProtocolToModelAdapter adapter = new ProtocolToModelAdapter();
    private final ToolingImplementationLoader toolingImplementationLoader;
    private final DefaultExecutorFactory executorFactory = new DefaultExecutorFactory();

    public ConnectionFactory(ToolingImplementationLoader toolingImplementationLoader) {
        this.toolingImplementationLoader = toolingImplementationLoader;
    }

    public ProjectConnection create(Distribution distribution, ConnectionParameters parameters) {
        SynchronizedLogging synchronizedLogging = new SynchronizedLogging();
        LazyConnection lazyConnection = new LazyConnection(distribution, this.toolingImplementationLoader, synchronizedLogging);
        ProgressLoggingConnection progressLoggingConnection = new ProgressLoggingConnection(lazyConnection, synchronizedLogging);
        LoggingInitializerConnection initializingConnection = new LoggingInitializerConnection(progressLoggingConnection, synchronizedLogging);
        DefaultAsyncConnection asyncConnection = new DefaultAsyncConnection(initializingConnection, (ExecutorFactory)this.executorFactory);
        return new DefaultProjectConnection(asyncConnection, this.adapter, parameters);
    }

    ToolingImplementationLoader getToolingImplementationLoader() {
        return this.toolingImplementationLoader;
    }
}

