/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializerRegistry
implements SerializerRegistry {
    private final Map<Class<?>, Serializer<?>> serializerMap = new TreeMap(new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });
    private final Set<Class<?>> javaSerialization = new HashSet();
    private final SerializerClassMatcherStrategy classMatcher;

    public DefaultSerializerRegistry() {
        this(true);
    }

    public DefaultSerializerRegistry(boolean supportClassHierarchy) {
        this.classMatcher = supportClassHierarchy ? SerializerClassMatcherStrategy.HIERARCHY : SerializerClassMatcherStrategy.STRICT;
    }

    @Override
    public <T> void register(Class<T> implementationType, Serializer<T> serializer) {
        this.serializerMap.put(implementationType, serializer);
    }

    @Override
    public <T> void useJavaSerialization(Class<T> implementationType) {
        this.javaSerialization.add(implementationType);
    }

    @Override
    public boolean canSerialize(Class<?> baseType) {
        for (Class<?> candidate : this.serializerMap.keySet()) {
            if (!this.classMatcher.matches(baseType, candidate)) continue;
            return true;
        }
        for (Class<?> candidate : this.javaSerialization) {
            if (!this.classMatcher.matches(baseType, candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> Serializer<T> build(Class<T> baseType) {
        LinkedHashMap matches = new LinkedHashMap();
        for (Map.Entry<Class<?>, Serializer<?>> entry : this.serializerMap.entrySet()) {
            if (!baseType.isAssignableFrom(entry.getKey())) continue;
            matches.put(entry.getKey(), entry.getValue());
        }
        LinkedHashSet matchingJavaSerialization = new LinkedHashSet();
        for (Class<?> candidate : this.javaSerialization) {
            if (!baseType.isAssignableFrom(candidate)) continue;
            matchingJavaSerialization.add(candidate);
        }
        if (matches.isEmpty() && matchingJavaSerialization.isEmpty()) {
            throw new IllegalArgumentException(String.format("Don't know how to serialize objects of type %s.", baseType.getName()));
        }
        if (matches.size() == 1 && matchingJavaSerialization.isEmpty()) {
            return (Serializer)matches.values().iterator().next();
        }
        return new TaggedTypeSerializer(matches, matchingJavaSerialization);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrictSerializerMatcher
    implements SerializerClassMatcherStrategy {
        private StrictSerializerMatcher() {
        }

        @Override
        public boolean matches(Class<?> baseType, Class<?> candidate) {
            return baseType.equals(candidate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HierarchySerializerMatcher
    implements SerializerClassMatcherStrategy {
        private HierarchySerializerMatcher() {
        }

        @Override
        public boolean matches(Class<?> baseType, Class<?> candidate) {
            return baseType.isAssignableFrom(candidate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SerializerClassMatcherStrategy {
        public static final SerializerClassMatcherStrategy STRICT = new StrictSerializerMatcher();
        public static final SerializerClassMatcherStrategy HIERARCHY = new HierarchySerializerMatcher();

        public boolean matches(Class<?> var1, Class<?> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaggedTypeSerializer<T>
    extends AbstractSerializer<T> {
        private static final int JAVA_TYPE = 1;
        private static final TypeInfo JAVA_SERIALIZATION = new TypeInfo(1, true, new DefaultSerializer());
        private final Map<Class<?>, TypeInfo> serializersByType = new HashMap();
        private final Map<Class<?>, TypeInfo> typeHierarchies = new HashMap();
        private final TypeInfo[] serializersByTag;

        public TaggedTypeSerializer(Map<Class<?>, Serializer<?>> serializerMap, Set<Class<?>> javaSerialization) {
            this.serializersByTag = new TypeInfo[2 + serializerMap.size()];
            this.serializersByTag[1] = JAVA_SERIALIZATION;
            int nextTag = 2;
            for (Map.Entry<Class<?>, Serializer<?>> entry : serializerMap.entrySet()) {
                this.add(nextTag, entry.getKey(), entry.getValue());
                ++nextTag;
            }
            for (Class clazz : javaSerialization) {
                this.serializersByType.put(clazz, JAVA_SERIALIZATION);
                this.typeHierarchies.put(clazz, JAVA_SERIALIZATION);
            }
        }

        private void add(int tag, Class<?> type, Serializer<?> serializer) {
            TypeInfo typeInfo = new TypeInfo(tag, type.equals(Throwable.class), serializer);
            this.serializersByType.put(type, typeInfo);
            this.serializersByTag[typeInfo.tag] = typeInfo;
            if (typeInfo.useForSubtypes) {
                this.typeHierarchies.put(type, typeInfo);
            }
        }

        @Override
        public T read(Decoder decoder) throws Exception {
            TypeInfo typeInfo;
            int tag = decoder.readSmallInt();
            TypeInfo typeInfo2 = typeInfo = tag >= this.serializersByTag.length ? null : this.serializersByTag[tag];
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Unexpected type tag %d found.", tag));
            }
            return typeInfo.serializer.read(decoder);
        }

        @Override
        public void write(Encoder encoder, T value) throws Exception {
            TypeInfo typeInfo = this.map(value.getClass());
            encoder.writeSmallInt(typeInfo.tag);
            typeInfo.serializer.write(encoder, value);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            TaggedTypeSerializer rhs = (TaggedTypeSerializer)obj;
            return Objects.equal(this.serializersByType, rhs.serializersByType) && Objects.equal(this.typeHierarchies, rhs.typeHierarchies) && Arrays.equals(this.serializersByTag, rhs.serializersByTag);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.serializersByType, this.typeHierarchies, Arrays.hashCode(this.serializersByTag)});
        }

        private TypeInfo map(Class<?> valueType) {
            TypeInfo typeInfo = this.serializersByType.get(valueType);
            if (typeInfo != null) {
                return typeInfo;
            }
            for (Map.Entry<Class<?>, TypeInfo> entry : this.typeHierarchies.entrySet()) {
                if (!entry.getKey().isAssignableFrom(valueType)) continue;
                return entry.getValue();
            }
            throw new IllegalArgumentException(String.format("Don't know how to serialize an object of type %s.", valueType.getName()));
        }
    }

    private static class TypeInfo {
        final int tag;
        final boolean useForSubtypes;
        final Serializer serializer;

        private TypeInfo(int tag, boolean useForSubtypes, Serializer serializer) {
            this.tag = tag;
            this.useForSubtypes = useForSubtypes;
            this.serializer = serializer;
        }
    }
}

