/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.util.Collection;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCollectionSerializer<T> {
    protected final Serializer<T> entrySerializer;

    public AbstractCollectionSerializer(Serializer<T> entrySerializer) {
        this.entrySerializer = entrySerializer;
    }

    protected void readValues(Decoder decoder, Collection<T> values) throws Exception {
        int size = decoder.readInt();
        for (int i = 0; i < size; ++i) {
            values.add(this.entrySerializer.read(decoder));
        }
    }

    protected void writeValues(Encoder encoder, Collection<T> value) throws Exception {
        encoder.writeInt(value.size());
        for (T t : value) {
            this.entrySerializer.write(encoder, t);
        }
    }
}

