/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenerManager
implements ListenerManager {
    private final Map<Object, ListenerDetails> allListeners = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Object, ListenerDetails> allLoggers = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Class<?>, EventBroadcast> broadcasters = new HashMap();
    private final Object lock = new Object();
    private final DefaultListenerManager parent;

    public DefaultListenerManager() {
        this(null);
    }

    private DefaultListenerManager(DefaultListenerManager parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.allListeners.containsKey(listener)) {
                ListenerDetails details = new ListenerDetails(listener);
                this.allListeners.put(listener, details);
                for (EventBroadcast broadcaster : this.broadcasters.values()) {
                    broadcaster.maybeAdd(details);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        Object object = this.lock;
        synchronized (object) {
            ListenerDetails details = this.allListeners.remove(listener);
            if (details != null) {
                details.disconnect();
                for (EventBroadcast broadcaster : this.broadcasters.values()) {
                    broadcaster.maybeRemove(details);
                }
                details.untilNotInUse(Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useLogger(Object logger) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.allLoggers.containsKey(logger)) {
                ListenerDetails details = new ListenerDetails(logger);
                this.allLoggers.put(logger, details);
                for (EventBroadcast broadcaster : this.broadcasters.values()) {
                    broadcaster.maybeSetLogger(details);
                }
            }
        }
    }

    @Override
    public <T> T getBroadcaster(Class<T> listenerClass) {
        return this.getBroadcasterInternal(listenerClass).getBroadcaster();
    }

    @Override
    public <T> ListenerBroadcast<T> createAnonymousBroadcaster(Class<T> listenerClass) {
        ListenerBroadcast<T> broadcast = new ListenerBroadcast<T>(listenerClass);
        broadcast.add(this.getBroadcasterInternal(listenerClass).getDispatch(true));
        return broadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> EventBroadcast<T> getBroadcasterInternal(Class<T> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            EventBroadcast<T> broadcaster = this.broadcasters.get(listenerClass);
            if (broadcaster == null) {
                broadcaster = new EventBroadcast<T>(listenerClass);
                this.broadcasters.put(listenerClass, broadcaster);
                for (ListenerDetails listener : this.allListeners.values()) {
                    broadcaster.maybeAdd(listener);
                }
                for (ListenerDetails logger : this.allLoggers.values()) {
                    broadcaster.maybeSetLogger(logger);
                }
            }
            return broadcaster;
        }
    }

    @Override
    public ListenerManager createChild() {
        return new DefaultListenerManager(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerDetails
    implements Dispatch<MethodInvocation> {
        final Object listener;
        final Dispatch<MethodInvocation> dispatch;
        final AtomicBoolean removed = new AtomicBoolean();
        Thread owner;

        public ListenerDetails(Object listener) {
            this.listener = listener;
            this.dispatch = new ReflectionDispatch(listener);
        }

        void disconnect() {
            this.removed.set(true);
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (!this.removed.get()) {
                this.dispatch.dispatch(message);
            }
        }

        public void startNotification(Thread owner) {
            this.untilNotInUse(owner);
            this.owner = owner;
        }

        public void untilNotInUse(Thread expectedOwner) {
            while (this.owner != null && this.owner != expectedOwner) {
                try {
                    DefaultListenerManager.this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }

        public void endNotification(Thread owner) {
            if (this.owner != owner && this.owner != null) {
                throw new IllegalStateException("Unexpected owner for listener.");
            }
            this.owner = null;
            DefaultListenerManager.this.lock.notifyAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventBroadcast<T> {
        private final Class<T> type;
        private final ProxyDispatchAdapter<T> source;
        private final ListenerDispatch dispatch;
        private final ListenerDispatch dispatchNoLogger;
        private final Set<ListenerDetails> listeners = new LinkedHashSet<ListenerDetails>();
        private ListenerDetails logger;
        private Dispatch<MethodInvocation> parentDispatch;
        private Thread owner;

        EventBroadcast(Class<T> type) {
            this.type = type;
            this.dispatch = new ListenerDispatch(type, true);
            this.dispatchNoLogger = new ListenerDispatch(type, false);
            if (DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(type).getDispatch(true);
            }
            this.source = new ProxyDispatchAdapter<T>(this.dispatch, type, new Class[0]);
        }

        Dispatch<MethodInvocation> getDispatch(boolean includeLogger) {
            return includeLogger ? this.dispatch : this.dispatchNoLogger;
        }

        T getBroadcaster() {
            return this.source.getSource();
        }

        void maybeAdd(ListenerDetails listener) {
            if (this.type.isInstance(listener.listener)) {
                this.listeners.add(listener);
            }
        }

        void maybeRemove(ListenerDetails listener) {
            this.listeners.remove(listener);
        }

        void maybeSetLogger(ListenerDetails candidate) {
            if (this.type.isInstance(candidate.listener)) {
                if (this.logger == null && DefaultListenerManager.this.parent != null) {
                    this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(this.type).getDispatch(false);
                }
                this.logger = candidate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Dispatch<MethodInvocation>> startNotification(boolean includeLogger) {
            Object object = DefaultListenerManager.this.lock;
            synchronized (object) {
                while (this.owner != null) {
                    if (this.owner == Thread.currentThread()) {
                        throw new IllegalStateException(String.format("Cannot notify listeners of type %s as these listeners are already being notified.", this.type.getSimpleName()));
                    }
                    try {
                        DefaultListenerManager.this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                this.owner = Thread.currentThread();
                ArrayList<Dispatch<MethodInvocation>> dispatchers = new ArrayList<Dispatch<MethodInvocation>>(this.listeners.size() + 2);
                if (includeLogger && this.logger != null) {
                    dispatchers.add(this.logger);
                }
                if (this.parentDispatch != null) {
                    dispatchers.add(this.parentDispatch);
                }
                for (ListenerDetails listener : this.listeners) {
                    listener.startNotification(this.owner);
                    dispatchers.add(listener);
                }
                return dispatchers;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endNotification(List<Dispatch<MethodInvocation>> dispatchers) {
            Object object = DefaultListenerManager.this.lock;
            synchronized (object) {
                for (Dispatch<MethodInvocation> dispatcher : dispatchers) {
                    if (!(dispatcher instanceof ListenerDetails)) continue;
                    ListenerDetails listener = (ListenerDetails)dispatcher;
                    listener.endNotification(this.owner);
                }
                this.owner = null;
                DefaultListenerManager.this.lock.notifyAll();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ListenerDispatch
        extends AbstractBroadcastDispatch<T> {
            private final boolean includeLogger;

            public ListenerDispatch(Class<T> type, boolean includeLogger) {
                super(type);
                this.includeLogger = includeLogger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(MethodInvocation invocation) {
                List dispatchers = EventBroadcast.this.startNotification(this.includeLogger);
                try {
                    this.dispatch(invocation, dispatchers.iterator());
                }
                finally {
                    EventBroadcast.this.endNotification(dispatchers);
                }
            }
        }
    }
}

