/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ConsumerAvailable;
import org.gradle.messaging.remote.internal.protocol.ConsumerUnavailable;
import org.gradle.messaging.remote.internal.protocol.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastSendProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnicastSendProtocol.class);
    private static final Object BROKEN_CONSUMER = new Object();
    private final List<Object> queue = new ArrayList<Object>();
    private String consumerDisplayName;
    private Object consumerId;
    private ProtocolContext<Message> context;
    private boolean stopping;

    @Override
    public void start(ProtocolContext<Message> context) {
        this.context = context;
    }

    @Override
    public void handleIncoming(Message message) {
        if (message instanceof ConsumerAvailable) {
            ConsumerAvailable consumerAvailable = (ConsumerAvailable)message;
            LOGGER.debug("Consumer available: {}", (Object)consumerAvailable);
            this.consumerId = consumerAvailable.getId();
            this.consumerDisplayName = consumerAvailable.getDisplayName();
            for (Object queued : this.queue) {
                this.context.dispatchOutgoing(new Request(this.consumerId, queued));
            }
            this.queue.clear();
            if (this.stopping) {
                LOGGER.debug("Queued messages dispatched. Stopping now.");
                this.context.stopped();
            }
        } else if (message instanceof ConsumerUnavailable) {
            this.consumerId = BROKEN_CONSUMER;
        } else {
            throw new IllegalArgumentException(String.format("Received unexpected incoming message: %s", message));
        }
    }

    @Override
    public void handleOutgoing(Message message) {
        if (message instanceof Request) {
            Request request = (Request)message;
            if (this.consumerId == null) {
                this.queue.add(request.getPayload());
            } else if (this.consumerId == BROKEN_CONSUMER) {
                LOGGER.warn("Discarding message {}, as {} is no longer available.", (Object)message, (Object)this.consumerDisplayName);
            } else {
                this.context.dispatchOutgoing(new Request(this.consumerId, request.getPayload()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Unexpected outgoing message dispatched: %s", message));
        }
    }

    @Override
    public void stopRequested() {
        if (this.queue.isEmpty()) {
            this.context.stopped();
            return;
        }
        LOGGER.debug("Waiting for outgoing messages to be dispatched to a consumer.");
        this.stopping = true;
        this.context.stopLater();
    }
}

