/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.nio.channels.SocketChannel;
import org.gradle.messaging.remote.internal.ConnectCompletion;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DefaultMessageSerializer;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.SocketConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketConnectCompletion
implements ConnectCompletion {
    private final SocketChannel socket;

    public SocketConnectCompletion(SocketChannel socket) {
        this.socket = socket;
    }

    public String toString() {
        return String.format("%s to %s", this.socket.socket().getLocalSocketAddress(), this.socket.socket().getRemoteSocketAddress());
    }

    @Override
    public <T> Connection<T> create(ClassLoader messageClassLoader) {
        return new SocketConnection(this.socket, new DefaultMessageSerializer(messageClassLoader));
    }

    @Override
    public <T> Connection<T> create(MessageSerializer<T> serializer) {
        return new SocketConnection<T>(this.socket, serializer);
    }
}

