/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectionAcceptor;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.ChannelRegistrationProtocol;
import org.gradle.messaging.remote.internal.ConnectCompletion;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.GroupMessageFilter;
import org.gradle.messaging.remote.internal.IncomingBroadcast;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageHub;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.ProtocolStack;
import org.gradle.messaging.remote.internal.TypeCastDispatch;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIncomingBroadcast
implements IncomingBroadcast,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncomingBroadcast.class);
    private final ProtocolStack<DiscoveryMessage> protocolStack;
    private final MessageOriginator messageOriginator;
    private final String group;
    private final Lock lock = new ReentrantLock();
    private final Set<String> channels = new HashSet<String>();
    private final StoppableExecutor executor;
    private final Address address;
    private final MessageHub hub;
    private final ConnectionAcceptor acceptor;

    public DefaultIncomingBroadcast(MessageOriginator messageOriginator, String group, AsyncConnection<DiscoveryMessage> connection, IncomingConnector incomingConnector, ExecutorFactory executorFactory, IdGenerator<UUID> idGenerator, ClassLoader messagingClassLoader) {
        this.messageOriginator = messageOriginator;
        this.group = group;
        this.executor = executorFactory.create("discovery broadcast");
        DiscardingFailureHandler failureHandler = new DiscardingFailureHandler(LOGGER);
        this.protocolStack = new ProtocolStack((Executor)this.executor, failureHandler, failureHandler, new ChannelRegistrationProtocol(messageOriginator));
        connection.dispatchTo(new GroupMessageFilter(group, this.protocolStack.getBottom()));
        this.protocolStack.getBottom().dispatchTo(connection);
        this.acceptor = incomingConnector.accept(new IncomingConnectionAction(), true);
        this.address = this.acceptor.getAddress();
        this.hub = new MessageHub("incoming broadcast", messageOriginator.getName(), executorFactory, idGenerator, messagingClassLoader);
        LOGGER.info("Created IncomingBroadcast with {}", (Object)messageOriginator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addIncoming(Class<T> type, T handler) {
        String channelKey = type.getName();
        this.lock.lock();
        try {
            if (this.channels.add(channelKey)) {
                this.protocolStack.getTop().dispatch(new ChannelAvailable(this.messageOriginator, this.group, channelKey, this.address));
            }
        }
        finally {
            this.lock.unlock();
        }
        this.hub.addIncoming(channelKey, new TypeCastDispatch(MethodInvocation.class, new ReflectionDispatch(handler)));
    }

    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.acceptor, this.protocolStack, this.hub, this.executor}).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncomingConnectionAction
    implements Action<ConnectCompletion> {
        private IncomingConnectionAction() {
        }

        public void execute(ConnectCompletion completion) {
            Connection<Message> connection = completion.create(this.getClass().getClassLoader());
            DefaultIncomingBroadcast.this.hub.addConnection(connection);
        }
    }
}

