/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.tasks.TaskDestroyables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskDestroyables
implements TaskDestroyables,
TaskDestroyablesInternal {
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private DefaultConfigurableFileCollection destroyFiles;

    public DefaultTaskDestroyables(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
    }

    public void files(final Object ... paths) {
        this.taskMutator.mutate("TaskDestroys.files(Object...)", new Runnable(){

            public void run() {
                DefaultTaskDestroyables.this.getFiles().from(paths);
            }
        });
    }

    public void file(final Object path) {
        this.taskMutator.mutate("TaskDestroys.file(Object...)", new Runnable(){

            public void run() {
                DefaultTaskDestroyables.this.getFiles().from(path);
            }
        });
    }

    public DefaultConfigurableFileCollection getFiles() {
        if (this.destroyFiles == null) {
            this.destroyFiles = new DefaultConfigurableFileCollection(this.task + " destroy files", this.resolver, null, new Object[0]);
        }
        return this.destroyFiles;
    }

    @Override
    public Collection<File> getFilesReadOnly() {
        if (this.destroyFiles != null) {
            return this.destroyFiles.getFiles();
        }
        return Collections.emptySet();
    }
}

