/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProviderFactory
implements ProviderFactory {
    public <T> Provider<T> provider(Callable<T> value) {
        if (value == null) {
            throw new InvalidUserDataException("Value cannot be null");
        }
        return new DefaultProvider<T>(value);
    }

    public <T> PropertyState<T> property(Class<T> type) {
        if (type == null) {
            throw new InvalidUserDataException("Class cannot be null");
        }
        DefaultPropertyState<T> propertyState = new DefaultPropertyState<T>(type);
        if (type == Boolean.class) {
            propertyState.set(Providers.FALSE);
        } else if (type == Byte.class) {
            propertyState.set(Providers.BYTE_ZERO);
        } else if (type == Short.class) {
            propertyState.set(Providers.SHORT_ZERO);
        } else if (type == Integer.class) {
            propertyState.set(Providers.INTEGER_ZERO);
        } else if (type == Long.class) {
            propertyState.set(Providers.LONG_ZERO);
        } else if (type == Float.class) {
            propertyState.set(Providers.FLOAT_ZERO);
        } else if (type == Double.class) {
            propertyState.set(Providers.DOUBLE_ZERO);
        } else if (type == Character.class) {
            propertyState.set(Providers.CHAR_ZERO);
        }
        return propertyState;
    }
}

