/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    AbstractInputPropertyAnnotationHandler() {
    }

    @Override
    public void attachActions(final TaskPropertyActionContext context) {
        PathSensitivity pathSensitivity;
        context.setValidationAction(new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, Collection<String> messages) {
                AbstractInputPropertyAnnotationHandler.this.validate(propertyName, value, messages);
            }
        });
        PathSensitive pathSensitive = context.getAnnotation(PathSensitive.class);
        if (pathSensitive == null) {
            if (context.isCacheable()) {
                context.validationMessage("is missing a @PathSensitive annotation, defaulting to PathSensitivity.ABSOLUTE");
            }
            pathSensitivity = PathSensitivity.ABSOLUTE;
        } else {
            pathSensitivity = pathSensitive.value();
        }
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, Callable<Object> futureValue) {
                TaskInputFilePropertyBuilder propertyBuilder = AbstractInputPropertyAnnotationHandler.this.createPropertyBuilder(context, task, futureValue);
                propertyBuilder.withPropertyName(context.getName()).withPathSensitivity(pathSensitivity).skipWhenEmpty(context.isAnnotationPresent(SkipWhenEmpty.class)).optional(context.isOptional());
            }
        });
    }

    protected abstract TaskInputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext var1, TaskInternal var2, Callable<Object> var3);

    protected abstract void validate(String var1, Object var2, Collection<String> var3);
}

