/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.RestrictiveCodeVisitor;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.plugin.internal.InvalidPluginIdException;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.plugin.use.internal.PluginRequestCollector;

public class PluginUseScriptBlockMetadataExtractor {
    public static final String NEED_SINGLE_BOOLEAN = "argument list must be exactly 1 literal boolean";
    public static final String NEED_SINGLE_STRING = "argument list must be exactly 1 literal non empty string";
    public static final String BASE_MESSAGE = "only id(String) method calls allowed in plugins {} script block";
    public static final String EXTENDED_MESSAGE = "only version(String) and apply(boolean) method calls allowed in plugins {} script block";
    private static final String NOT_LITERAL_METHOD_NAME = "method name must be literal (i.e. not a variable)";
    private static final String NOT_LITERAL_ID_METHOD_NAME = "only id(String) method calls allowed in plugins {} script block - method name must be literal (i.e. not a variable)";
    private final DocumentationRegistry documentationRegistry;
    private final PluginRequestCollector pluginRequestCollector;

    public PluginUseScriptBlockMetadataExtractor(ScriptSource scriptSource, DocumentationRegistry documentationRegistry) {
        this.pluginRequestCollector = new PluginRequestCollector(scriptSource);
        this.documentationRegistry = documentationRegistry;
    }

    public void extract(SourceUnit sourceUnit, ScriptBlock scriptBlock) {
        ClosureExpression closureArg = scriptBlock.getClosureExpression();
        closureArg.getCode().visit((GroovyCodeVisitor)new RestrictiveCodeVisitor(sourceUnit, this.formatErrorMessage(BASE_MESSAGE)){

            public void visitBlockStatement(BlockStatement block) {
                for (Statement statement : block.getStatements()) {
                    statement.visit((GroovyCodeVisitor)this);
                }
            }

            public void visitMethodCallExpression(MethodCallExpression call) {
                if (!call.isImplicitThis()) {
                    Expression target = call.getObjectExpression();
                    if (!(target instanceof MethodCallExpression)) {
                        this.restrict((ASTNode)target, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                        return;
                    }
                    this.visitMethodCallExpression((MethodCallExpression)target);
                }
                if (call.getMethod() instanceof ConstantExpression) {
                    ConstantExpression methodName = (ConstantExpression)call.getMethod();
                    if (AstUtils.isOfType((ConstantExpression)methodName, String.class)) {
                        String methodNameText = methodName.getText();
                        if (methodNameText.equals("id") || methodNameText.equals("version")) {
                            ConstantExpression argumentExpression = AstUtils.hasSingleConstantArgOfType((MethodCallExpression)call, String.class);
                            if (argumentExpression == null) {
                                this.restrict((ASTNode)call, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.NEED_SINGLE_STRING));
                                return;
                            }
                            String argStringValue = argumentExpression.getValue().toString();
                            if (argStringValue.length() == 0) {
                                this.restrict((ASTNode)argumentExpression, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.NEED_SINGLE_STRING));
                                return;
                            }
                            if (methodName.getText().equals("id")) {
                                if (call.isImplicitThis()) {
                                    try {
                                        DefaultPluginId.validate(argStringValue);
                                        call.setNodeMetaData(PluginDependencySpec.class, (Object)PluginUseScriptBlockMetadataExtractor.this.pluginRequestCollector.createSpec(call.getLineNumber()).id(argStringValue));
                                    }
                                    catch (InvalidPluginIdException e) {
                                        this.restrict((ASTNode)argumentExpression, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(e.getReason()));
                                    }
                                } else {
                                    this.restrict((ASTNode)call, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                                }
                            }
                            if (methodName.getText().equals("version")) {
                                PluginDependencySpec spec = this.getSpecFor(call);
                                if (spec == null) {
                                    return;
                                }
                                spec.version(argStringValue);
                                call.setNodeMetaData(PluginDependencySpec.class, (Object)spec);
                            }
                        } else if (methodNameText.equals("apply")) {
                            ConstantExpression arguments = AstUtils.hasSingleConstantArgOfType((MethodCallExpression)call, Boolean.TYPE);
                            if (arguments == null) {
                                this.restrict((ASTNode)call, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.NEED_SINGLE_BOOLEAN));
                                return;
                            }
                            PluginDependencySpec spec = this.getSpecFor(call);
                            if (spec == null) {
                                return;
                            }
                            spec.apply((Boolean)arguments.getValue());
                        } else if (!call.isImplicitThis()) {
                            this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.EXTENDED_MESSAGE));
                        } else {
                            this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                        }
                    } else {
                        this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.NOT_LITERAL_ID_METHOD_NAME));
                    }
                } else {
                    this.restrict((ASTNode)call);
                }
            }

            private PluginDependencySpec getSpecFor(MethodCallExpression call) {
                Expression objectExpression = call.getObjectExpression();
                if (objectExpression instanceof MethodCallExpression) {
                    return (PluginDependencySpec)objectExpression.getNodeMetaData(PluginDependencySpec.class);
                }
                this.restrict((ASTNode)call, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                return null;
            }

            public void visitExpressionStatement(ExpressionStatement statement) {
                statement.getExpression().visit((GroovyCodeVisitor)this);
            }
        });
    }

    public PluginRequests getPluginRequests() {
        return this.pluginRequestCollector.getPluginRequests();
    }

    public String formatErrorMessage(String message) {
        return String.format("%s%n%nSee %s for information on the plugins {} block%n%n", message, this.documentationRegistry.getDocumentationFor("plugins", "sec:plugins_block"));
    }
}

