/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProducerGuard<T> {
    public static <T> ProducerGuard<T> adaptive() {
        return new AdaptiveProducerGuard();
    }

    public static <T> ProducerGuard<T> striped() {
        return new StripedProducerGuard();
    }

    public static <T> ProducerGuard<T> serial() {
        return new SerialProducerGuard();
    }

    private ProducerGuard() {
    }

    public abstract <V> V guardByKey(T var1, Factory<V> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerialProducerGuard<T>
    extends ProducerGuard<T> {
        private final Lock lock = new ReentrantLock();

        private SerialProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Factory<V> factory) {
            try {
                this.lock.lock();
                Object object = factory.create();
                return (V)object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StripedProducerGuard<T>
    extends ProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Factory<V> factory) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                Object object = factory.create();
                return (V)object;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdaptiveProducerGuard<T>
    extends ProducerGuard<T> {
        private final Set<T> producing = Sets.newHashSet();

        private AdaptiveProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Factory<V> factory) {
            Object object = this.producing;
            synchronized (object) {
                while (!this.producing.add(key)) {
                    try {
                        this.producing.wait();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            }
            try {
                object = factory.create();
                return (V)object;
            }
            finally {
                Set<T> set = this.producing;
                synchronized (set) {
                    this.producing.remove(key);
                    this.producing.notifyAll();
                }
            }
        }
    }
}

