/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMutator {
    private final TaskInternal task;
    private boolean executingleftShiftAction;

    public TaskMutator(TaskInternal task) {
        this.task = task;
    }

    public void mutate(String method, Runnable action) {
        if (!this.task.getState().isConfigurable()) {
            throw new IllegalStateException(this.format(method));
        }
        action.run();
    }

    public <T> T mutate(String method, Callable<T> action) {
        if (!this.task.getState().isConfigurable()) {
            throw new IllegalStateException(this.format(method));
        }
        return (T)GUtil.uncheckedCall(action);
    }

    public void assertMutable(String listname, PropertyChangeEvent evt) {
        if (this.task.getState().isConfigurable()) {
            return;
        }
        String method = null;
        if (evt instanceof ObservableList.ElementEvent) {
            switch (((ObservableList.ElementEvent)evt).getChangeType()) {
                case ADDED: {
                    method = String.format("%s.%s", listname, "add()");
                    break;
                }
                case UPDATED: {
                    method = String.format("%s.%s", listname, "set(int, Object)");
                    break;
                }
                case REMOVED: {
                    method = String.format("%s.%s", listname, "remove()");
                    break;
                }
                case CLEARED: {
                    method = String.format("%s.%s", listname, "clear()");
                    break;
                }
                case MULTI_ADD: {
                    method = String.format("%s.%s", listname, "addAll()");
                    break;
                }
                case MULTI_REMOVE: {
                    method = String.format("%s.%s", listname, "removeAll()");
                }
            }
        }
        if (method == null) {
            return;
        }
        throw new IllegalStateException(this.format(method));
    }

    public ContextAwareTaskAction leftShift(ContextAwareTaskAction action) {
        return new LeftShiftTaskAction(action);
    }

    private String format(String method) {
        if (this.executingleftShiftAction) {
            return String.format("Cannot call %s on %s after task has started execution. Check the configuration of %s as you may have misused '<<' at task declaration.", method, this.task, this.task);
        }
        return String.format("Cannot call %s on %s after task has started execution.", method, this.task);
    }

    private class LeftShiftTaskAction
    implements ContextAwareTaskAction {
        private final ContextAwareTaskAction action;

        public LeftShiftTaskAction(ContextAwareTaskAction action) {
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Task task) {
            TaskMutator.this.executingleftShiftAction = true;
            try {
                this.action.execute(task);
            }
            finally {
                TaskMutator.this.executingleftShiftAction = false;
            }
        }

        public void contextualise(TaskExecutionContext context) {
            this.action.contextualise(context);
        }

        public void releaseContext() {
            this.action.releaseContext();
        }

        public ClassLoader getClassLoader() {
            return this.action.getClassLoader();
        }

        public String getActionClassName() {
            return this.action.getActionClassName();
        }
    }
}

