/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginMetadata;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZipTaskOutputPacker
implements TaskOutputPacker {
    private final TaskOutputPacker delegate;

    public GZipTaskOutputPacker(TaskOutputPacker delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, OutputStream output, TaskOutputOriginWriter writeOrigin) {
        GZIPOutputStream gzipOutput = this.createGzipOutputStream(output);
        try {
            this.delegate.pack(propertySpecs, gzipOutput, writeOrigin);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)gzipOutput);
        }
    }

    private GZIPOutputStream createGzipOutputStream(OutputStream output) {
        try {
            return new GZIPOutputStream(output);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputOriginMetadata unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, InputStream input, TaskOutputOriginReader readOrigin) {
        GZIPInputStream gzipInput = this.createGzipInputStream(input);
        try {
            TaskOutputOriginMetadata taskOutputOriginMetadata = this.delegate.unpack(propertySpecs, gzipInput, readOrigin);
            return taskOutputOriginMetadata;
        }
        finally {
            IOUtils.closeQuietly((InputStream)gzipInput);
        }
    }

    private GZIPInputStream createGzipInputStream(InputStream input) {
        try {
            return new GZIPInputStream(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

