/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks.origin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.gradle.api.internal.TaskInternal;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginMetadata;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.time.TimeProvider;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskOutputOriginFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskOutputOriginFactory.class);
    private static final String BUILD_INVOCATION_ID_KEY = "buildInvocationId";
    private static final List<String> METADATA_KEYS = Arrays.asList("buildInvocationId", "type", "path", "gradleVersion", "creationTime", "executionTime", "rootPath", "operatingSystem", "hostName", "userName");
    private final InetAddressFactory inetAddressFactory;
    private final String userName;
    private final String operatingSystem;
    private final TimeProvider timeProvider;
    private final GradleVersion gradleVersion;
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final File rootDir;

    public TaskOutputOriginFactory(TimeProvider timeProvider, InetAddressFactory inetAddressFactory, File rootDir, String userName, String operatingSystem, GradleVersion gradleVersion, BuildInvocationScopeId buildInvocationScopeId) {
        this.inetAddressFactory = inetAddressFactory;
        this.rootDir = rootDir;
        this.userName = userName;
        this.operatingSystem = operatingSystem;
        this.timeProvider = timeProvider;
        this.gradleVersion = gradleVersion;
        this.buildInvocationScopeId = buildInvocationScopeId;
    }

    public TaskOutputOriginWriter createWriter(final TaskInternal task, final long elapsedTime) {
        return new TaskOutputOriginWriter(){

            public void execute(OutputStream outputStream) {
                Properties properties = new Properties();
                properties.setProperty(TaskOutputOriginFactory.BUILD_INVOCATION_ID_KEY, TaskOutputOriginFactory.this.buildInvocationScopeId.getId().asString());
                properties.setProperty("type", task.getClass().getCanonicalName());
                properties.setProperty("path", task.getPath());
                properties.setProperty("gradleVersion", TaskOutputOriginFactory.this.gradleVersion.getVersion());
                properties.setProperty("creationTime", Long.toString(TaskOutputOriginFactory.this.timeProvider.getCurrentTime()));
                properties.setProperty("executionTime", Long.toString(elapsedTime));
                properties.setProperty("rootPath", TaskOutputOriginFactory.this.rootDir.getAbsolutePath());
                properties.setProperty("operatingSystem", TaskOutputOriginFactory.this.operatingSystem);
                properties.setProperty("hostName", TaskOutputOriginFactory.this.inetAddressFactory.getHostname());
                properties.setProperty("userName", TaskOutputOriginFactory.this.userName);
                try {
                    properties.store(outputStream, "Generated origin information");
                }
                catch (IOException e) {
                    UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                assert (METADATA_KEYS.containsAll(properties.stringPropertyNames())) : "Update expected metadata property list";
            }
        };
    }

    public TaskOutputOriginReader createReader(final TaskInternal task) {
        return new TaskOutputOriginReader(){

            public TaskOutputOriginMetadata execute(InputStream inputStream) {
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                if (!properties.stringPropertyNames().containsAll(METADATA_KEYS)) {
                    throw new IllegalStateException("Cached result format error, corrupted origin metadata.");
                }
                LOGGER.info("Origin for {}: {}", (Object)task, (Object)properties);
                String originBuildInvocationIdString = properties.getProperty(TaskOutputOriginFactory.BUILD_INVOCATION_ID_KEY);
                UniqueId originBuildInvocationId = UniqueId.from((String)originBuildInvocationIdString);
                return new TaskOutputOriginMetadata(originBuildInvocationId);
            }
        };
    }
}

