/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Transformer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.DefaultProducerGuard;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIndexedCache<K, V>
implements PersistentIndexedCache<K, V> {
    private final Map<Object, byte[]> entries = new ConcurrentHashMap<Object, byte[]>();
    private final ProducerGuard<K> producerGuard = new DefaultProducerGuard<K>();
    private final Serializer<V> valueSerializer;

    public InMemoryIndexedCache(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public V get(K key) {
        byte[] serialised = this.entries.get(key);
        if (serialised == null) {
            return null;
        }
        try {
            ByteArrayInputStream instr = new ByteArrayInputStream(serialised);
            InputStreamBackedDecoder decoder = new InputStreamBackedDecoder((InputStream)instr);
            return (V)this.valueSerializer.read((Decoder)decoder);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public V get(final K key, final Transformer<? extends V, ? super K> producer) {
        return this.producerGuard.guardByKey(key, new Factory<V>(){

            public V create() {
                if (!InMemoryIndexedCache.this.entries.containsKey(key)) {
                    InMemoryIndexedCache.this.put(key, producer.transform(key));
                }
                return InMemoryIndexedCache.this.get(key);
            }
        });
    }

    @Override
    public void put(K key, V value) {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder((OutputStream)outstr);
        try {
            this.valueSerializer.write((Encoder)encoder, value);
            encoder.flush();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.entries.put(key, outstr.toByteArray());
    }

    @Override
    public void remove(K key) {
        this.entries.remove(key);
    }

    public Set<K> keySet() {
        return this.entries.keySet();
    }
}

