/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ProcessForkOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessForkOptions
implements ProcessForkOptions {
    private final PathToFileResolver resolver;
    private Object executable;
    private Factory<File> workingDir;
    private Map<String, Object> environment;

    public DefaultProcessForkOptions(PathToFileResolver resolver) {
        this.resolver = resolver;
        this.workingDir = resolver.resolveLater((Object)".");
    }

    public String getExecutable() {
        return this.executable == null ? null : this.executable.toString();
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setExecutable(Object executable) {
        this.executable = executable;
    }

    public ProcessForkOptions executable(Object executable) {
        this.setExecutable(executable);
        return this;
    }

    public File getWorkingDir() {
        return (File)this.workingDir.create();
    }

    public void setWorkingDir(File dir) {
        this.workingDir = this.resolver.resolveLater((Object)dir);
    }

    public void setWorkingDir(Object dir) {
        this.workingDir = this.resolver.resolveLater(dir);
    }

    public ProcessForkOptions workingDir(Object dir) {
        this.setWorkingDir(dir);
        return this;
    }

    public Map<String, Object> getEnvironment() {
        if (this.environment == null) {
            this.setEnvironment(Jvm.current().getInheritableEnvironmentVariables(System.getenv()));
        }
        return this.environment;
    }

    public Map<String, String> getActualEnvironment() {
        HashMap<String, String> actual = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.getEnvironment().entrySet()) {
            actual.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return actual;
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.environment = Maps.newHashMap(environmentVariables);
    }

    public ProcessForkOptions environment(String name, Object value) {
        this.getEnvironment().put(name, value);
        return this;
    }

    public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
        this.getEnvironment().putAll(environmentVariables);
        return this;
    }

    public ProcessForkOptions copyTo(ProcessForkOptions target) {
        target.setExecutable(this.executable);
        target.setWorkingDir(this.workingDir);
        target.setEnvironment(this.getEnvironment());
        return this;
    }
}

